/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.identifiers.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.identifiers.IdBasedNetworkElementIdentifier;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifierContingencyList;
import com.powsybl.iidm.network.identifiers.VoltageLevelAndOrderNetworkElementIdentifier;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class IdentifierDeserializer
extends StdDeserializer<NetworkElementIdentifier> {
    private static final String CONTEXT_NAME = "Identifier";
    private static final String CONTINGENCY_ID = "contingencyId";
    public static final String IDENTIFIER_LIST_VERSION = "identifierListVersion";

    public IdentifierDeserializer() {
        super(NetworkElementIdentifier.class);
    }

    public NetworkElementIdentifier deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        Enum type = null;
        String identifier = null;
        String voltageLevelId1 = null;
        String voltageLevelId2 = null;
        String contingencyId = null;
        String version = JsonUtil.getSourceVersion((DatabindContext)deserializationContext, (String)IDENTIFIER_LIST_VERSION);
        List networkElementIdentifierList = Collections.emptyList();
        char order = '\u0000';
        block23: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "type": {
                    type = NetworkElementIdentifier.IdentifierType.valueOf(parser.nextTextValue());
                    continue block23;
                }
                case "identifier": {
                    identifier = parser.nextTextValue();
                    continue block23;
                }
                case "contingencyId": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)CONTINGENCY_ID, (String)version, (String)"1.2");
                    contingencyId = parser.nextTextValue();
                    continue block23;
                }
                case "identifierList": {
                    parser.nextToken();
                    networkElementIdentifierList = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, NetworkElementIdentifier.class);
                    continue block23;
                }
                case "voltageLevelId1": {
                    voltageLevelId1 = parser.nextTextValue();
                    continue block23;
                }
                case "voltageLevelId2": {
                    voltageLevelId2 = parser.nextTextValue();
                    continue block23;
                }
                case "order": {
                    String orderStr = parser.nextTextValue();
                    if (orderStr.length() != 1) {
                        throw new IllegalArgumentException("order is one character");
                    }
                    order = orderStr.charAt(0);
                    continue block23;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        if (type == null) {
            throw new IllegalArgumentException("type of identifier can not be null");
        }
        return switch (1.$SwitchMap$com$powsybl$iidm$network$identifiers$NetworkElementIdentifier$IdentifierType[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new IdBasedNetworkElementIdentifier(identifier, contingencyId);
            case 2 -> new NetworkElementIdentifierContingencyList(networkElementIdentifierList, contingencyId);
            case 3 -> new VoltageLevelAndOrderNetworkElementIdentifier(voltageLevelId1, voltageLevelId2, order, contingencyId);
        };
    }
}

