/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.commons.util.Colors;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import org.anarres.graphviz.builder.GraphVizAttribute;
import org.anarres.graphviz.builder.GraphVizCluster;
import org.anarres.graphviz.builder.GraphVizEdge;
import org.anarres.graphviz.builder.GraphVizGraph;
import org.anarres.graphviz.builder.GraphVizNode;
import org.anarres.graphviz.builder.GraphVizScope;

public class GraphvizConnectivity {
    private static final String NEWLINE = "&#13;&#10;";
    private final Network network;
    private final Random random;
    private boolean countryCluster = false;

    public GraphvizConnectivity(Network network) {
        this(network, new SecureRandom());
    }

    public GraphvizConnectivity(Network network, Random random) {
        this.network = Objects.requireNonNull(network);
        this.random = Objects.requireNonNull(random);
    }

    public GraphvizConnectivity setCountryCluster(boolean countryCluster) {
        this.countryCluster = countryCluster;
        return this;
    }

    private static String getBusId(Bus bus) {
        return bus.getId().replace('-', '_').replace("=", "_");
    }

    public void write(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.write(writer);
        }
    }

    public void write(Writer writer) {
        Objects.requireNonNull(writer);
        GraphVizGraph graph = new GraphVizGraph().label((CharSequence)this.network.getId());
        GraphVizScope.Impl scope = new GraphVizScope.Impl();
        int maxCC = this.network.getBusView().getBusStream().mapToInt(b -> b.getConnectedComponent().getNum()).max().getAsInt();
        String[] colors = Colors.generateColorScale((int)(maxCC + 1), (Random)this.random);
        for (Bus b2 : this.network.getBusView().getBuses()) {
            long load = Math.round(b2.getLoadStream().mapToDouble(Load::getP0).sum());
            long maxGeneration = Math.round(b2.getGeneratorStream().mapToDouble(Generator::getMaxP).sum());
            String busId = GraphvizConnectivity.getBusId(b2);
            String tooltip = "load=" + load + "MW&#13;&#10;max generation=" + maxGeneration + "MW&#13;&#10;cc=" + b2.getConnectedComponent().getNum();
            GraphVizNode node = (GraphVizNode)((GraphVizNode)((GraphVizNode)((GraphVizNode)((GraphVizNode)((GraphVizNode)graph.node((GraphVizScope)scope, (Object)busId).label((CharSequence)busId)).attr(GraphVizAttribute.shape, "ellipse")).attr(GraphVizAttribute.style, "filled")).attr(GraphVizAttribute.fontsize, "10")).attr(GraphVizAttribute.fillcolor, colors[b2.getConnectedComponent().getNum()])).attr(GraphVizAttribute.tooltip, tooltip);
            if (!this.countryCluster) continue;
            b2.getVoltageLevel().getSubstation().flatMap(Substation::getCountry).ifPresent(arg_0 -> GraphvizConnectivity.lambda$write$1(graph, (GraphVizScope)scope, node, arg_0));
        }
        for (Branch branch : this.network.getBranches()) {
            Bus b1 = branch.getTerminal1().getBusView().getBus();
            Bus b2 = branch.getTerminal2().getBusView().getBus();
            if (b1 == null || b2 == null) continue;
            GraphVizEdge edge = graph.edge((GraphVizScope)scope, (Object)GraphvizConnectivity.getBusId(b1), (Object)GraphvizConnectivity.getBusId(b2));
            edge.label().append((CharSequence)branch.getId()).append((CharSequence)System.lineSeparator());
        }
        try {
            graph.writeTo(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static /* synthetic */ void lambda$write$1(GraphVizGraph graph, GraphVizScope scope, GraphVizNode node, Country country) {
        ((GraphVizCluster)((GraphVizCluster)graph.cluster(scope, (Object)country).label((CharSequence)country.name())).attr(GraphVizAttribute.style, "rounded")).add(new GraphVizNode[]{node});
    }
}

