/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.DanglingLineData;
import com.powsybl.iidm.network.util.SV;
import java.util.Objects;

public class DanglingLineBoundaryImpl
implements Boundary {
    private final DanglingLine parent;

    public DanglingLineBoundaryImpl(DanglingLine parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    @Override
    public double getV() {
        if (DanglingLineBoundaryImpl.useHypothesis(this.parent)) {
            DanglingLineData danglingLineData = new DanglingLineData(this.parent);
            return danglingLineData.getBoundaryBusU();
        }
        Terminal t = this.parent.getTerminal();
        Bus b = t.getBusView().getBus();
        if (DanglingLineData.zeroImpedance(this.parent)) {
            return DanglingLineBoundaryImpl.getV(b);
        }
        return new SV(t.getP(), t.getQ(), DanglingLineBoundaryImpl.getV(b), DanglingLineBoundaryImpl.getAngle(b), TwoSides.ONE).otherSideU(this.parent, false);
    }

    @Override
    public double getAngle() {
        if (DanglingLineBoundaryImpl.useHypothesis(this.parent)) {
            DanglingLineData danglingLineData = new DanglingLineData(this.parent);
            return Math.toDegrees(danglingLineData.getBoundaryBusTheta());
        }
        Terminal t = this.parent.getTerminal();
        Bus b = t.getBusView().getBus();
        if (DanglingLineData.zeroImpedance(this.parent)) {
            return DanglingLineBoundaryImpl.getAngle(b);
        }
        return new SV(t.getP(), t.getQ(), DanglingLineBoundaryImpl.getV(b), DanglingLineBoundaryImpl.getAngle(b), TwoSides.ONE).otherSideA(this.parent, false);
    }

    @Override
    public double getP() {
        if (DanglingLineBoundaryImpl.useHypothesis(this.parent)) {
            return -this.parent.getP0();
        }
        Terminal t = this.parent.getTerminal();
        Bus b = t.getBusView().getBus();
        if (DanglingLineData.zeroImpedance(this.parent)) {
            return -t.getP();
        }
        return new SV(t.getP(), t.getQ(), DanglingLineBoundaryImpl.getV(b), DanglingLineBoundaryImpl.getAngle(b), TwoSides.ONE).otherSideP(this.parent, false);
    }

    @Override
    public double getQ() {
        if (DanglingLineBoundaryImpl.useHypothesis(this.parent)) {
            return -this.parent.getQ0();
        }
        Terminal t = this.parent.getTerminal();
        Bus b = t.getBusView().getBus();
        if (DanglingLineData.zeroImpedance(this.parent)) {
            return -t.getQ();
        }
        return new SV(t.getP(), t.getQ(), DanglingLineBoundaryImpl.getV(b), DanglingLineBoundaryImpl.getAngle(b), TwoSides.ONE).otherSideQ(this.parent, false);
    }

    @Override
    public DanglingLine getDanglingLine() {
        return this.parent;
    }

    @Override
    public VoltageLevel getNetworkSideVoltageLevel() {
        return this.parent.getTerminal().getVoltageLevel();
    }

    private static double getV(Bus b) {
        return b == null ? Double.NaN : b.getV();
    }

    private static double getAngle(Bus b) {
        return b == null ? Double.NaN : b.getAngle();
    }

    private static boolean valid(double p0, double q0) {
        return !Double.isNaN(p0) && !Double.isNaN(q0);
    }

    private static boolean useHypothesis(DanglingLine parent) {
        return !parent.isPaired() && DanglingLineBoundaryImpl.valid(parent.getP0(), parent.getQ0()) && parent.getGeneration() == null;
    }
}

