/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import java.util.Comparator;

public final class LoadingLimitsUtil {
    public static final Comparator<Integer> ACCEPTABLE_DURATION_COMPARATOR = (acceptableDuration1, acceptableDuration2) -> acceptableDuration2 - acceptableDuration1;

    private LoadingLimitsUtil() {
    }

    public static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> void fixMissingPermanentLimit(LoadingLimitsAdder<L, A> limitsAdder, double missingPermanentLimitPercentage) {
        LoadingLimitsUtil.fixMissingPermanentLimit(limitsAdder, missingPermanentLimitPercentage, "", LimitFixLogger.NO_OP);
    }

    public static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> void fixMissingPermanentLimit(LoadingLimitsAdder<L, A> adder, double missingPermanentLimitPercentage, String ownerId, LimitFixLogger limitFixLogger) {
        if (!Double.isNaN(adder.getPermanentLimit())) {
            return;
        }
        double lowestTemporaryLimitWithInfiniteAcceptableDuration = 2.147483647E9;
        boolean hasTemporaryLimitWithInfiniteAcceptableDuration = false;
        for (String name : adder.getTemporaryLimitNames()) {
            if (adder.getTemporaryLimitAcceptableDuration(name) != Integer.MAX_VALUE) continue;
            hasTemporaryLimitWithInfiniteAcceptableDuration = true;
            lowestTemporaryLimitWithInfiniteAcceptableDuration = Math.min(lowestTemporaryLimitWithInfiniteAcceptableDuration, adder.getTemporaryLimitValue(name));
            adder.removeTemporaryLimit(name);
        }
        if (hasTemporaryLimitWithInfiniteAcceptableDuration) {
            limitFixLogger.log("Operational Limits of " + ownerId, "Operational limits without permanent limit is considered with permanent limit equal to lowest temporary limit value with infinite acceptable duration", Double.NaN, lowestTemporaryLimitWithInfiniteAcceptableDuration);
            adder.setPermanentLimit(lowestTemporaryLimitWithInfiniteAcceptableDuration);
        } else {
            double firstTemporaryLimit = adder.getLowestTemporaryLimitValue();
            double percentage = missingPermanentLimitPercentage / 100.0;
            double fixedPermanentLimit = firstTemporaryLimit * percentage;
            limitFixLogger.log("Operational Limits of " + ownerId, "Operational limits without permanent limit is considered with permanent limit equal to lowest temporary limit value weighted by a coefficient of " + percentage + ".", Double.NaN, fixedPermanentLimit);
            adder.setPermanentLimit(fixedPermanentLimit);
        }
    }

    public static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> A initializeFromLoadingLimits(A adder, L limits) {
        adder.setPermanentLimit(limits.getPermanentLimit());
        limits.getTemporaryLimits().forEach(limit -> adder.beginTemporaryLimit().setName(limit.getName()).setAcceptableDuration(limit.getAcceptableDuration()).setValue(limit.getValue()).setFictitious(limit.isFictitious()).endTemporaryLimit());
        return adder;
    }

    public static interface LimitFixLogger {
        public static final LimitFixLogger NO_OP = (what, reason, wrongValue, fixedValue) -> {};

        public void log(String var1, String var2, double var3, double var5);
    }
}

