/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraversalType;
import com.powsybl.math.graph.TraverseResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public interface Terminal {
    public VoltageLevel getVoltageLevel();

    public NodeBreakerView getNodeBreakerView();

    public BusBreakerView getBusBreakerView();

    public BusView getBusView();

    public Connectable getConnectable();

    public double getP();

    public Terminal setP(double var1);

    public double getQ();

    public Terminal setQ(double var1);

    public double getI();

    public boolean connect();

    public boolean connect(Predicate<Switch> var1);

    public boolean disconnect();

    public boolean disconnect(Predicate<Switch> var1);

    public boolean isConnected();

    public void traverse(TopologyTraverser var1);

    public void traverse(TopologyTraverser var1, TraversalType var2);

    public static Optional<ThreeSides> getConnectableSide(Terminal terminal) {
        Connectable c = terminal.getConnectable();
        if (c instanceof Injection) {
            return Optional.empty();
        }
        if (c instanceof Branch) {
            Branch branch = (Branch)((Object)c);
            return Optional.of(branch.getSide(terminal).toThreeSides());
        }
        if (c instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer transformer = (ThreeWindingsTransformer)c;
            return Optional.of(transformer.getSide(terminal));
        }
        throw new IllegalStateException("Unexpected Connectable instance: " + c.getClass());
    }

    public static Terminal getTerminal(Identifiable<?> identifiable, ThreeSides side) {
        if (identifiable instanceof Injection) {
            Injection injection = (Injection)identifiable;
            return injection.getTerminal();
        }
        if (identifiable instanceof Branch) {
            Branch branch = (Branch)identifiable;
            return branch.getTerminal(side.toTwoSides());
        }
        if (identifiable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer transformer = (ThreeWindingsTransformer)identifiable;
            return transformer.getTerminal(side);
        }
        throw new PowsyblException("Unexpected terminal reference identifiable instance: " + identifiable.getClass());
    }

    public ThreeSides getSide();

    public List<Object> getReferrers();

    public static interface TopologyTraverser {
        public TraverseResult traverse(Terminal var1, boolean var2);

        public TraverseResult traverse(Switch var1);
    }

    public static interface BusView {
        public Bus getBus();

        public Bus getConnectableBus();
    }

    public static interface BusBreakerView {
        public Bus getBus();

        public Bus getConnectableBus();

        public void setConnectableBus(String var1);

        public void moveConnectable(String var1, boolean var2);
    }

    public static interface NodeBreakerView {
        public int getNode();

        public void moveConnectable(int var1, String var2);
    }
}

