/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.TopologyKind;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;

public enum TopologyLevel {
    NODE_BREAKER(TopologyKind.NODE_BREAKER),
    BUS_BREAKER(TopologyKind.BUS_BREAKER),
    BUS_BRANCH(TopologyKind.BUS_BREAKER);

    private final TopologyKind topologyKind;

    private TopologyLevel(TopologyKind topologyKind) {
        this.topologyKind = Objects.requireNonNull(topologyKind);
    }

    public TopologyKind getTopologyKind() {
        return this.topologyKind;
    }

    public static TopologyLevel min(TopologyKind topologyKind, TopologyLevel topologyLevel) {
        Objects.requireNonNull(topologyKind);
        Objects.requireNonNull(topologyLevel);
        TopologyLevel level = topologyKind == TopologyKind.NODE_BREAKER ? NODE_BREAKER : BUS_BREAKER;
        return Collections.max(EnumSet.of(level, topologyLevel));
    }
}

