/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.limitmodification.LimitsComputer;
import com.powsybl.iidm.network.limitmodification.result.AbstractDistinctLimitsContainer;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import com.powsybl.iidm.network.util.OverloadImpl;
import com.powsybl.iidm.network.util.PermanentLimitCheckResult;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public final class LimitViolationUtils {
    public static final String PERMANENT_LIMIT_NAME = "permanent";

    private LimitViolationUtils() {
    }

    public static Overload checkTemporaryLimits(Branch<?> branch, TwoSides side, double limitReductionValue, double i, LimitType type) {
        Objects.requireNonNull(branch);
        Objects.requireNonNull(side);
        return LimitViolationUtils.getLimits(branch, side.toThreeSides(), type, LimitsComputer.NO_MODIFICATIONS).map(limits -> LimitViolationUtils.getOverload((LoadingLimits)limits.getLimits(), i, limitReductionValue)).orElse(null);
    }

    public static Overload checkTemporaryLimits(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, double i, LimitType type) {
        Objects.requireNonNull(transformer);
        Objects.requireNonNull(side);
        return LimitViolationUtils.getLimits(transformer, side, type, LimitsComputer.NO_MODIFICATIONS).map(limits -> LimitViolationUtils.getOverload((LoadingLimits)limits.getLimits(), i, limitReductionValue)).orElse(null);
    }

    public static Overload checkTemporaryLimits(Branch<?> branch, TwoSides side, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, double i, LimitType type) {
        Objects.requireNonNull(branch);
        Objects.requireNonNull(side);
        return LimitViolationUtils.getLimits(branch, side.toThreeSides(), type, limitsComputer).map(limits -> LimitViolationUtils.getOverload(limits, i)).orElse(null);
    }

    public static Overload checkTemporaryLimits(ThreeWindingsTransformer transformer, ThreeSides side, LimitsComputer<Identifiable<?>, LoadingLimits> limitsComputer, double i, LimitType type) {
        Objects.requireNonNull(transformer);
        Objects.requireNonNull(side);
        return LimitViolationUtils.getLimits(transformer, side, type, limitsComputer).map(limits -> LimitViolationUtils.getOverload(limits, i)).orElse(null);
    }

    private static OverloadImpl getOverload(LoadingLimits limits, double i, double limitReductionValue) {
        double permanentLimit = limits.getPermanentLimit();
        if (Double.isNaN(i) || Double.isNaN(permanentLimit)) {
            return null;
        }
        Collection<LoadingLimits.TemporaryLimit> temporaryLimits = limits.getTemporaryLimits();
        String previousLimitName = PERMANENT_LIMIT_NAME;
        double previousLimit = permanentLimit;
        for (LoadingLimits.TemporaryLimit tl : temporaryLimits) {
            if (i >= previousLimit * limitReductionValue && i < tl.getValue() * limitReductionValue) {
                return new OverloadImpl(tl, previousLimitName, previousLimit);
            }
            previousLimitName = tl.getName();
            previousLimit = tl.getValue();
        }
        return null;
    }

    private static Overload getOverload(LimitsContainer<LoadingLimits> limitsContainer, double i) {
        double permanentLimit = limitsContainer.getLimits().getPermanentLimit();
        if (Double.isNaN(i) || Double.isNaN(permanentLimit)) {
            return null;
        }
        Collection<LoadingLimits.TemporaryLimit> temporaryLimits = limitsContainer.getLimits().getTemporaryLimits();
        String previousLimitName = PERMANENT_LIMIT_NAME;
        double previousLimit = permanentLimit;
        int previousAcceptableDuration = 0;
        boolean isFirstTemporaryLimit = true;
        for (LoadingLimits.TemporaryLimit tl : temporaryLimits) {
            if (i >= previousLimit && i < tl.getValue()) {
                double limit = previousLimit;
                double reduction = 1.0;
                if (limitsContainer.isDistinct()) {
                    AbstractDistinctLimitsContainer container = (AbstractDistinctLimitsContainer)limitsContainer;
                    if (isFirstTemporaryLimit) {
                        limit = container.getOriginalPermanentLimit();
                        reduction = container.getPermanentLimitReduction();
                    } else {
                        limit = container.getOriginalTemporaryLimit(previousAcceptableDuration);
                        reduction = container.getTemporaryLimitReduction(previousAcceptableDuration);
                    }
                }
                return new OverloadImpl(tl, previousLimitName, limit, reduction);
            }
            isFirstTemporaryLimit = false;
            previousLimitName = tl.getName();
            previousLimit = tl.getValue();
            previousAcceptableDuration = tl.getAcceptableDuration();
        }
        return null;
    }

    private static PermanentLimitCheckResult checkPermanentLimitIfAny(LimitsContainer<LoadingLimits> limitsContainer, double i) {
        return LimitViolationUtils.checkPermanentLimitIfAny(limitsContainer, i, 1.0);
    }

    private static PermanentLimitCheckResult checkPermanentLimitIfAny(LimitsContainer<LoadingLimits> limitsContainer, double i, double limitReductionValue) {
        double permanentLimit = limitsContainer.getLimits().getPermanentLimit();
        if (Double.isNaN(i) || Double.isNaN(permanentLimit)) {
            return new PermanentLimitCheckResult(false, limitReductionValue);
        }
        if (i >= permanentLimit * limitReductionValue) {
            return new PermanentLimitCheckResult(true, limitsContainer.isDistinct() ? ((AbstractDistinctLimitsContainer)limitsContainer).getPermanentLimitReduction() : limitReductionValue);
        }
        return new PermanentLimitCheckResult(false, limitReductionValue);
    }

    public static boolean checkPermanentLimit(Branch<?> branch, TwoSides side, double limitReductionValue, double i, LimitType type) {
        return LimitViolationUtils.getLimits(branch, side.toThreeSides(), type, LimitsComputer.NO_MODIFICATIONS).map(l -> LimitViolationUtils.checkPermanentLimitIfAny(l, i, limitReductionValue).isOverload()).orElse(false);
    }

    public static PermanentLimitCheckResult checkPermanentLimit(Branch<?> branch, TwoSides side, double i, LimitType type, LimitsComputer<Identifiable<?>, LoadingLimits> computer) {
        return LimitViolationUtils.getLimits(branch, side.toThreeSides(), type, computer).map(l -> LimitViolationUtils.checkPermanentLimitIfAny(l, i)).orElse(new PermanentLimitCheckResult(false, 1.0));
    }

    public static boolean checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, double i, LimitType type) {
        return LimitViolationUtils.getLimits(transformer, side, type, LimitsComputer.NO_MODIFICATIONS).map(l -> LimitViolationUtils.checkPermanentLimitIfAny(l, i, limitReductionValue).isOverload()).orElse(false);
    }

    public static PermanentLimitCheckResult checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, LimitsComputer<Identifiable<?>, LoadingLimits> computer, double i, LimitType type) {
        return LimitViolationUtils.getLimits(transformer, side, type, computer).map(l -> LimitViolationUtils.checkPermanentLimitIfAny(l, i)).orElse(null);
    }

    public static double getValueForLimit(Terminal t, LimitType type) {
        return switch (type) {
            case LimitType.ACTIVE_POWER -> t.getP();
            case LimitType.APPARENT_POWER -> Math.sqrt(t.getP() * t.getP() + t.getQ() * t.getQ());
            case LimitType.CURRENT -> t.getI();
            default -> throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
        };
    }

    public static boolean checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit(transformer, side, limitReductionValue, LimitViolationUtils.getValueForLimit(transformer.getTerminal(side), type), type);
    }

    public static PermanentLimitCheckResult checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, LimitType type, LimitsComputer<Identifiable<?>, LoadingLimits> computer) {
        return LimitViolationUtils.checkPermanentLimit(transformer, side, computer, LimitViolationUtils.getValueForLimit(transformer.getTerminal(side), type), type);
    }

    public static Overload checkTemporaryLimits(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits(transformer, side, limitReductionValue, LimitViolationUtils.getValueForLimit(transformer.getTerminal(side), type), type);
    }

    public static Overload checkTemporaryLimits(ThreeWindingsTransformer transformer, ThreeSides side, LimitType type, LimitsComputer<Identifiable<?>, LoadingLimits> computer) {
        return LimitViolationUtils.checkTemporaryLimits(transformer, side, computer, LimitViolationUtils.getValueForLimit(transformer.getTerminal(side), type), type);
    }

    public static Optional<? extends LimitsContainer<LoadingLimits>> getLimits(Identifiable<?> transformer, ThreeSides side, LimitType type, LimitsComputer<Identifiable<?>, LoadingLimits> computer) {
        return computer.computeLimits(transformer, type, side, false);
    }

    @Deprecated(since="6.4.0")
    public static Optional<? extends LoadingLimits> getLimits(Branch<?> branch, TwoSides side, LimitType type) {
        return branch.getLimits(type, side);
    }

    @Deprecated(since="6.4.0")
    public static Optional<? extends LoadingLimits> getLimits(ThreeWindingsTransformer transformer, ThreeSides side, LimitType type) {
        return transformer.getLeg(side).getLimits(type);
    }

    public static Optional<LoadingLimits> getLoadingLimits(Identifiable<?> identifiable, LimitType limitType, ThreeSides side) {
        return switch (identifiable.getType()) {
            case IdentifiableType.LINE -> ((Line)identifiable).getLimits(limitType, side.toTwoSides());
            case IdentifiableType.TIE_LINE -> ((TieLine)identifiable).getLimits(limitType, side.toTwoSides());
            case IdentifiableType.TWO_WINDINGS_TRANSFORMER -> ((TwoWindingsTransformer)identifiable).getLimits(limitType, side.toTwoSides());
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> ((ThreeWindingsTransformer)identifiable).getLeg(side).getLimits(limitType);
            default -> Optional.empty();
        };
    }
}

