/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.identifiers;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class IdWithWildcardsNetworkElementIdentifier
implements NetworkElementIdentifier {
    private String identifier;
    public static final char WILDCARD = '?';
    public static final int ALLOWED_WILDCARDS_NUMBER = 5;
    private final String contingencyId;

    public IdWithWildcardsNetworkElementIdentifier(String identifier) {
        this(identifier, null);
    }

    public IdWithWildcardsNetworkElementIdentifier(String identifier, String contingencyId) {
        this.identifier = Objects.requireNonNull(identifier);
        this.contingencyId = contingencyId;
        this.initialize();
    }

    private void initialize() {
        String allowedCharactersRegex = "^[A-Za-z0-9_?.-]*$";
        if (!this.identifier.matches(allowedCharactersRegex)) {
            throw new PowsyblException("Only characters allowed for this identifier are letters, numbers, '_', '-', '.' and the wildcard character '?'");
        }
        int separatorNumber = StringUtils.countMatches((CharSequence)this.identifier, (char)'?');
        if (separatorNumber > 5) {
            throw new PowsyblException("There can be a maximum of 5 wildcards ('?')");
        }
        if (separatorNumber == 0) {
            throw new PowsyblException("There is no wildcard in your identifier, please use IdBasedNetworkElementIdentifier instead");
        }
        this.identifier = this.identifier.replace(".", "\\.").replace('?', '.');
    }

    @Override
    public Set<Identifiable> filterIdentifiable(Network network) {
        return network.getIdentifiables().stream().filter(identifiable -> identifiable.getId().matches(this.identifier)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<String> getNotFoundElements(Network network) {
        Identifiable<?> identifiable = network.getIdentifiable(this.identifier);
        return identifiable == null ? Collections.singleton(this.identifier) : Collections.emptySet();
    }

    @Override
    public NetworkElementIdentifier.IdentifierType getType() {
        return NetworkElementIdentifier.IdentifierType.ID_WITH_WILDCARDS;
    }

    @Override
    public Optional<String> getContingencyId() {
        return Optional.ofNullable(this.contingencyId);
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

