/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Identifiable;
import java.util.Collection;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Identifiables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Identifiables.class);

    private Identifiables() {
    }

    public static <T extends Identifiable> Collection<T> sort(Iterable<T> identifiables) {
        TreeMap<String, Identifiable> sortedIdentifiables = new TreeMap<String, Identifiable>();
        for (Identifiable identifiable : identifiables) {
            sortedIdentifiables.put(identifiable.getId(), identifiable);
        }
        return sortedIdentifiables.values();
    }

    public static String getNullableId(Identifiable identifiable) {
        return identifiable == null ? null : identifiable.getId();
    }

    public static String getUniqueId(String baseId, Predicate<String> containsId) {
        String uniqueId;
        String checkedBaseId;
        if (baseId != null && baseId.length() > 0) {
            if (!containsId.test(baseId)) {
                return baseId;
            }
            checkedBaseId = baseId;
        } else {
            checkedBaseId = "autoid";
        }
        int i = 0;
        do {
            uniqueId = checkedBaseId + "#" + i++;
        } while (i < Integer.MAX_VALUE && containsId.test(uniqueId));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Object '{}' is not unique, rename to '{}'", (Object)baseId, (Object)uniqueId);
        }
        return uniqueId;
    }
}

