/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public final class Exporters {
    private Exporters() {
    }

    public static DataSource createDataSource(Path file, DataSourceObserver observer) {
        Objects.requireNonNull(file);
        if (Files.exists(file, new LinkOption[0]) && !Files.isRegularFile(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("File " + file + " already exists and is neither a regular file nor a directory"));
        }
        return DataSourceUtil.createDataSource((Path)file, (DataSourceObserver)observer);
    }

    public static DataSource createDataSource(Path file) {
        return Exporters.createDataSource(file, null);
    }
}

