/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ShortIdDictionary {
    private final Map<String, String> map = new HashMap<String, String>();

    public ShortIdDictionary(Set<String> ids) {
        char c = 'A';
        for (String id : ids) {
            if (this.map.containsKey(id)) continue;
            char c2 = c;
            c = (char)(c + 1);
            this.map.put(id, Character.toString(c2));
        }
    }

    public ShortIdDictionary(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(";");
                this.map.put(tokens[0], tokens[1]);
            }
        }
    }

    public String getShortId(String realId) {
        return this.map.get(realId);
    }

    public void write(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Map.Entry<String, String> e : this.map.entrySet()) {
                writer.write(e.getKey());
                writer.write(";");
                writer.write(e.getValue());
                writer.newLine();
            }
        }
    }
}

