/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.LinkData;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class TwtData {
    private final String id;
    private final double p1;
    private final double q1;
    private final double p2;
    private final double q2;
    private final double p3;
    private final double q3;
    private final double u1;
    private final double theta1;
    private final double u2;
    private final double theta2;
    private final double u3;
    private final double theta3;
    private final double r1;
    private final double x1;
    private final double r2;
    private final double x2;
    private final double r3;
    private final double x3;
    private final double g11;
    private final double b11;
    private final double g12;
    private final double b12;
    private final double g21;
    private final double b21;
    private final double g22;
    private final double b22;
    private final double g31;
    private final double b31;
    private final double g32;
    private final double b32;
    private final double rho1;
    private final double alpha1;
    private final double rho2;
    private final double alpha2;
    private final double rho3;
    private final double alpha3;
    private final double ratedU1;
    private final double ratedU2;
    private final double ratedU3;
    private final boolean connected1;
    private final boolean connected2;
    private final boolean connected3;
    private final boolean mainComponent1;
    private final boolean mainComponent2;
    private final boolean mainComponent3;
    private double computedP1;
    private double computedQ1;
    private double computedP2;
    private double computedQ2;
    private double computedP3;
    private double computedQ3;
    private double starU;
    private double starTheta;
    private final int phaseAngleClock2;
    private final int phaseAngleClock3;
    private final double ratedU0;

    public TwtData(ThreeWindingsTransformer twt, double epsilonX, boolean applyReactanceCorrection) {
        this(twt, 0, 0, epsilonX, applyReactanceCorrection, false);
    }

    public TwtData(ThreeWindingsTransformer twt, double epsilonX, boolean applyReactanceCorrection, boolean twtSplitShuntAdmittance) {
        this(twt, 0, 0, epsilonX, applyReactanceCorrection, twtSplitShuntAdmittance);
    }

    public TwtData(ThreeWindingsTransformer twt, int phaseAngleClock2, int phaseAngleClock3, double epsilonX, boolean applyReactanceCorrection, boolean twtSplitShuntAdmittance) {
        Objects.requireNonNull(twt);
        this.id = twt.getId();
        this.p1 = twt.getLeg1().getTerminal().getP();
        this.q1 = twt.getLeg1().getTerminal().getQ();
        this.p2 = twt.getLeg2().getTerminal().getP();
        this.q2 = twt.getLeg2().getTerminal().getQ();
        this.p3 = twt.getLeg3().getTerminal().getP();
        this.q3 = twt.getLeg3().getTerminal().getQ();
        this.u1 = TwtData.getV(twt.getLeg1());
        this.theta1 = TwtData.getTheta(twt.getLeg1());
        this.u2 = TwtData.getV(twt.getLeg2());
        this.theta2 = TwtData.getTheta(twt.getLeg2());
        this.u3 = TwtData.getV(twt.getLeg3());
        this.theta3 = TwtData.getTheta(twt.getLeg3());
        this.r1 = TwtData.getR(twt.getLeg1());
        this.x1 = LinkData.getFixedX(TwtData.getX(twt.getLeg1()), epsilonX, applyReactanceCorrection);
        this.r2 = TwtData.getR(twt.getLeg2());
        this.x2 = LinkData.getFixedX(TwtData.getX(twt.getLeg2()), epsilonX, applyReactanceCorrection);
        this.r3 = TwtData.getR(twt.getLeg3());
        this.x3 = LinkData.getFixedX(TwtData.getX(twt.getLeg3()), epsilonX, applyReactanceCorrection);
        this.g11 = TwtData.getG1(twt.getLeg1(), twtSplitShuntAdmittance);
        this.b11 = TwtData.getB1(twt.getLeg1(), twtSplitShuntAdmittance);
        this.g12 = TwtData.getG2(twt.getLeg1(), twtSplitShuntAdmittance);
        this.b12 = TwtData.getB2(twt.getLeg1(), twtSplitShuntAdmittance);
        this.g21 = TwtData.getG1(twt.getLeg2(), twtSplitShuntAdmittance);
        this.b21 = TwtData.getB1(twt.getLeg2(), twtSplitShuntAdmittance);
        this.g22 = TwtData.getG2(twt.getLeg2(), twtSplitShuntAdmittance);
        this.b22 = TwtData.getB2(twt.getLeg2(), twtSplitShuntAdmittance);
        this.g31 = TwtData.getG1(twt.getLeg3(), twtSplitShuntAdmittance);
        this.b31 = TwtData.getB1(twt.getLeg3(), twtSplitShuntAdmittance);
        this.g32 = TwtData.getG2(twt.getLeg3(), twtSplitShuntAdmittance);
        this.b32 = TwtData.getB2(twt.getLeg3(), twtSplitShuntAdmittance);
        this.ratedU0 = twt.getRatedU0();
        this.phaseAngleClock2 = phaseAngleClock2;
        this.phaseAngleClock3 = phaseAngleClock3;
        this.rho1 = TwtData.rho(twt.getLeg1(), this.ratedU0);
        this.alpha1 = TwtData.alpha(twt.getLeg1());
        this.rho2 = TwtData.rho(twt.getLeg2(), this.ratedU0);
        this.alpha2 = TwtData.alpha(twt.getLeg2());
        this.rho3 = TwtData.rho(twt.getLeg3(), this.ratedU0);
        this.alpha3 = TwtData.alpha(twt.getLeg3());
        this.ratedU1 = twt.getLeg1().getRatedU();
        this.ratedU2 = twt.getLeg2().getRatedU();
        this.ratedU3 = twt.getLeg3().getRatedU();
        double rhof = 1.0;
        double alphaf = 0.0;
        double angle1 = -this.alpha1;
        double angle2 = -this.alpha2 - Math.toRadians(LinkData.getPhaseAngleClockDegrees(phaseAngleClock2));
        double angle3 = -this.alpha3 - Math.toRadians(LinkData.getPhaseAngleClockDegrees(phaseAngleClock3));
        double anglef = -alphaf;
        LinkData.BranchAdmittanceMatrix branchAdmittanceLeg1 = LinkData.calculateBranchAdmittance(this.r1, this.x1, 1.0 / this.rho1, angle1, 1.0 / rhof, anglef, new Complex(this.g11, this.b11), new Complex(this.g12, this.b12));
        LinkData.BranchAdmittanceMatrix branchAdmittanceLeg2 = LinkData.calculateBranchAdmittance(this.r2, this.x2, 1.0 / this.rho2, angle2, 1.0 / rhof, anglef, new Complex(this.g21, this.b21), new Complex(this.g22, this.b22));
        LinkData.BranchAdmittanceMatrix branchAdmittanceLeg3 = LinkData.calculateBranchAdmittance(this.r3, this.x3, 1.0 / this.rho3, angle3, 1.0 / rhof, anglef, new Complex(this.g31, this.b31), new Complex(this.g32, this.b32));
        this.connected1 = twt.getLeg1().getTerminal().isConnected();
        this.connected2 = twt.getLeg2().getTerminal().isConnected();
        this.connected3 = twt.getLeg3().getTerminal().isConnected();
        this.mainComponent1 = TwtData.isMainComponent(twt.getLeg1());
        this.mainComponent2 = TwtData.isMainComponent(twt.getLeg2());
        this.mainComponent3 = TwtData.isMainComponent(twt.getLeg3());
        if (this.connected1 && this.connected2 && this.connected3 && TwtData.valid(this.u1, this.theta1) && TwtData.valid(this.u2, this.theta2) && TwtData.valid(this.u3, this.theta3)) {
            this.calculateThreeConnectedLegsFlowAndStarBusVoltage(this.u1, this.theta1, this.u2, this.theta2, this.u3, this.theta3, branchAdmittanceLeg1, branchAdmittanceLeg2, branchAdmittanceLeg3);
        } else if (this.connected1 && this.connected2 && TwtData.valid(this.u1, this.theta1) && TwtData.valid(this.u2, this.theta2)) {
            LinkData.Flow flow = this.calculateTwoConnectedLegsFlow(this.u1, this.theta1, this.u2, this.theta2, branchAdmittanceLeg1, branchAdmittanceLeg2, branchAdmittanceLeg3);
            this.computedP1 = flow.fromTo.getReal();
            this.computedQ1 = flow.fromTo.getImaginary();
            this.computedP2 = flow.toFrom.getReal();
            this.computedQ2 = flow.toFrom.getImaginary();
            this.computedP3 = 0.0;
            this.computedQ3 = 0.0;
            Complex v0 = this.calculateTwoConnectedLegsStarBusVoltage(this.u1, this.theta1, this.u2, this.theta2, branchAdmittanceLeg1, branchAdmittanceLeg2, branchAdmittanceLeg3);
            this.starU = v0.abs();
            this.starTheta = v0.getArgument();
        } else if (this.connected1 && this.connected3 && TwtData.valid(this.u1, this.theta1) && TwtData.valid(this.u3, this.theta3)) {
            LinkData.Flow flow = this.calculateTwoConnectedLegsFlow(this.u1, this.theta1, this.u3, this.theta3, branchAdmittanceLeg1, branchAdmittanceLeg3, branchAdmittanceLeg2);
            this.computedP1 = flow.fromTo.getReal();
            this.computedQ1 = flow.fromTo.getImaginary();
            this.computedP2 = 0.0;
            this.computedQ2 = 0.0;
            this.computedP3 = flow.toFrom.getReal();
            this.computedQ3 = flow.toFrom.getImaginary();
            Complex v0 = this.calculateTwoConnectedLegsStarBusVoltage(this.u1, this.theta1, this.u3, this.theta3, branchAdmittanceLeg1, branchAdmittanceLeg3, branchAdmittanceLeg2);
            this.starU = v0.abs();
            this.starTheta = v0.getArgument();
        } else if (this.connected2 && this.connected3 && TwtData.valid(this.u2, this.theta2) && TwtData.valid(this.u3, this.theta3)) {
            LinkData.Flow flow = this.calculateTwoConnectedLegsFlow(this.u2, this.theta2, this.u3, this.theta3, branchAdmittanceLeg2, branchAdmittanceLeg3, branchAdmittanceLeg1);
            this.computedP1 = 0.0;
            this.computedQ1 = 0.0;
            this.computedP2 = flow.fromTo.getReal();
            this.computedQ2 = flow.fromTo.getImaginary();
            this.computedP3 = flow.toFrom.getReal();
            this.computedQ3 = flow.toFrom.getImaginary();
            Complex v0 = this.calculateTwoConnectedLegsStarBusVoltage(this.u2, this.theta2, this.u3, this.theta3, branchAdmittanceLeg2, branchAdmittanceLeg3, branchAdmittanceLeg1);
            this.starU = v0.abs();
            this.starTheta = v0.getArgument();
        } else if (this.connected1 && TwtData.valid(this.u1, this.theta1)) {
            Complex flow = this.calculateOneConnectedLegFlow(this.u1, this.theta1, branchAdmittanceLeg1, branchAdmittanceLeg2, branchAdmittanceLeg3);
            this.computedP1 = flow.getReal();
            this.computedQ1 = flow.getImaginary();
            this.computedP2 = 0.0;
            this.computedQ2 = 0.0;
            this.computedP3 = 0.0;
            this.computedQ3 = 0.0;
            Complex v0 = this.calculateOneConnectedLegStarBusVoltage(this.u1, this.theta1, branchAdmittanceLeg1, branchAdmittanceLeg2, branchAdmittanceLeg3);
            this.starU = v0.abs();
            this.starTheta = v0.getArgument();
        } else if (this.connected2 && TwtData.valid(this.u2, this.theta2)) {
            Complex flow = this.calculateOneConnectedLegFlow(this.u2, this.theta2, branchAdmittanceLeg2, branchAdmittanceLeg1, branchAdmittanceLeg3);
            this.computedP1 = 0.0;
            this.computedQ1 = 0.0;
            this.computedP2 = flow.getReal();
            this.computedQ2 = flow.getImaginary();
            this.computedP3 = 0.0;
            this.computedQ3 = 0.0;
            Complex v0 = this.calculateOneConnectedLegStarBusVoltage(this.u2, this.theta2, branchAdmittanceLeg2, branchAdmittanceLeg1, branchAdmittanceLeg3);
            this.starU = v0.abs();
            this.starTheta = v0.getArgument();
        } else if (this.connected3 && TwtData.valid(this.u3, this.theta3)) {
            Complex flow = this.calculateOneConnectedLegFlow(this.u3, this.theta3, branchAdmittanceLeg3, branchAdmittanceLeg1, branchAdmittanceLeg2);
            this.computedP1 = 0.0;
            this.computedQ1 = 0.0;
            this.computedP2 = 0.0;
            this.computedQ2 = 0.0;
            this.computedP3 = flow.getReal();
            this.computedQ3 = flow.getImaginary();
            Complex v0 = this.calculateOneConnectedLegStarBusVoltage(this.u3, this.theta3, branchAdmittanceLeg3, branchAdmittanceLeg1, branchAdmittanceLeg2);
            this.starU = v0.abs();
            this.starTheta = v0.getArgument();
        } else {
            this.computedP1 = Double.NaN;
            this.computedQ1 = Double.NaN;
            this.computedP2 = Double.NaN;
            this.computedQ2 = Double.NaN;
            this.computedP3 = Double.NaN;
            this.computedQ3 = Double.NaN;
            this.starU = Double.NaN;
            this.starTheta = Double.NaN;
        }
    }

    private void calculateThreeConnectedLegsFlowAndStarBusVoltage(double u1, double theta1, double u2, double theta2, double u3, double theta3, LinkData.BranchAdmittanceMatrix branchAdmittanceLeg1, LinkData.BranchAdmittanceMatrix branchAdmittanceLeg2, LinkData.BranchAdmittanceMatrix branchAdmittanceLeg3) {
        Complex v1 = ComplexUtils.polar2Complex((double)u1, (double)theta1);
        Complex v2 = ComplexUtils.polar2Complex((double)u2, (double)theta2);
        Complex v3 = ComplexUtils.polar2Complex((double)u3, (double)theta3);
        Complex v0 = branchAdmittanceLeg1.y21().multiply(v1).add(branchAdmittanceLeg2.y21().multiply(v2)).add(branchAdmittanceLeg3.y21().multiply(v3)).negate().divide(branchAdmittanceLeg1.y22().add(branchAdmittanceLeg2.y22()).add(branchAdmittanceLeg3.y22()));
        LinkData.Flow flowLeg1 = LinkData.flowBothEnds(branchAdmittanceLeg1.y11(), branchAdmittanceLeg1.y12(), branchAdmittanceLeg1.y21(), branchAdmittanceLeg1.y22(), v1, v0);
        LinkData.Flow flowLeg2 = LinkData.flowBothEnds(branchAdmittanceLeg2.y11(), branchAdmittanceLeg2.y12(), branchAdmittanceLeg2.y21(), branchAdmittanceLeg2.y22(), v2, v0);
        LinkData.Flow flowLeg3 = LinkData.flowBothEnds(branchAdmittanceLeg3.y11(), branchAdmittanceLeg3.y12(), branchAdmittanceLeg3.y21(), branchAdmittanceLeg3.y22(), v3, v0);
        this.computedP1 = flowLeg1.fromTo.getReal();
        this.computedQ1 = flowLeg1.fromTo.getImaginary();
        this.computedP2 = flowLeg2.fromTo.getReal();
        this.computedQ2 = flowLeg2.fromTo.getImaginary();
        this.computedP3 = flowLeg3.fromTo.getReal();
        this.computedQ3 = flowLeg3.fromTo.getImaginary();
        this.starU = v0.abs();
        this.starTheta = v0.getArgument();
    }

    private LinkData.Flow calculateTwoConnectedLegsFlow(double u1, double theta1, double u2, double theta2, LinkData.BranchAdmittanceMatrix admittanceMatrixLeg1, LinkData.BranchAdmittanceMatrix admittanceMatrixLeg2, LinkData.BranchAdmittanceMatrix admittanceMatrixOpenLeg) {
        Complex v1 = ComplexUtils.polar2Complex((double)u1, (double)theta1);
        Complex v2 = ComplexUtils.polar2Complex((double)u2, (double)theta2);
        LinkData.BranchAdmittanceMatrix admittance = this.calculateTwoConnectedLegsAdmittance(admittanceMatrixLeg1, admittanceMatrixLeg2, admittanceMatrixOpenLeg);
        return LinkData.flowBothEnds(admittance.y11(), admittance.y12(), admittance.y21(), admittance.y22(), v1, v2);
    }

    private Complex calculateTwoConnectedLegsStarBusVoltage(double u1, double theta1, double u2, double theta2, LinkData.BranchAdmittanceMatrix admittanceMatrixLeg1, LinkData.BranchAdmittanceMatrix admittanceMatrixLeg2, LinkData.BranchAdmittanceMatrix admittanceMatrixOpenLeg) {
        Complex v1 = ComplexUtils.polar2Complex((double)u1, (double)theta1);
        Complex v2 = ComplexUtils.polar2Complex((double)u2, (double)theta2);
        Complex yshO = LinkData.kronAntenna(admittanceMatrixOpenLeg.y11(), admittanceMatrixOpenLeg.y12(), admittanceMatrixOpenLeg.y21(), admittanceMatrixOpenLeg.y22(), true);
        return admittanceMatrixLeg1.y21().multiply(v1).add(admittanceMatrixLeg2.y21().multiply(v2)).negate().divide(admittanceMatrixLeg1.y22().add(admittanceMatrixLeg2.y22()).add(yshO));
    }

    private Complex calculateOneConnectedLegFlow(double u, double theta, LinkData.BranchAdmittanceMatrix admittanceMatrixLeg, LinkData.BranchAdmittanceMatrix admittanceMatrixFirstOpenLeg, LinkData.BranchAdmittanceMatrix admittanceMatrixSecondOpenLeg) {
        Complex ysh = this.calculateOneConnectedLegShunt(admittanceMatrixLeg, admittanceMatrixFirstOpenLeg, admittanceMatrixSecondOpenLeg);
        return LinkData.flowYshunt(ysh, u, theta);
    }

    private Complex calculateOneConnectedLegStarBusVoltage(double u, double theta, LinkData.BranchAdmittanceMatrix admittanceMatrixLeg, LinkData.BranchAdmittanceMatrix admittanceMatrixFirstOpenLeg, LinkData.BranchAdmittanceMatrix admittanceMatrixSecondOpenLeg) {
        Complex v = ComplexUtils.polar2Complex((double)u, (double)theta);
        Complex ysh1O = LinkData.kronAntenna(admittanceMatrixFirstOpenLeg.y11(), admittanceMatrixFirstOpenLeg.y12(), admittanceMatrixFirstOpenLeg.y21(), admittanceMatrixFirstOpenLeg.y22(), true);
        Complex ysh2O = LinkData.kronAntenna(admittanceMatrixSecondOpenLeg.y11(), admittanceMatrixSecondOpenLeg.y12(), admittanceMatrixSecondOpenLeg.y21(), admittanceMatrixSecondOpenLeg.y22(), true);
        return admittanceMatrixLeg.y21().multiply(v).negate().divide(admittanceMatrixLeg.y22().add(ysh1O).add(ysh2O));
    }

    private LinkData.BranchAdmittanceMatrix calculateTwoConnectedLegsAdmittance(LinkData.BranchAdmittanceMatrix firstCloseLeg, LinkData.BranchAdmittanceMatrix secondCloseLeg, LinkData.BranchAdmittanceMatrix openLeg) {
        Complex ysh = LinkData.kronAntenna(openLeg.y11(), openLeg.y12(), openLeg.y21(), openLeg.y22(), true);
        LinkData.BranchAdmittanceMatrix secondCloseLegMod = new LinkData.BranchAdmittanceMatrix(secondCloseLeg.y11(), secondCloseLeg.y12(), secondCloseLeg.y21(), secondCloseLeg.y22().add(ysh));
        return LinkData.kronChain(firstCloseLeg, TwoSides.TWO, secondCloseLegMod, TwoSides.TWO);
    }

    private Complex calculateOneConnectedLegShunt(LinkData.BranchAdmittanceMatrix closeLeg, LinkData.BranchAdmittanceMatrix firstOpenLeg, LinkData.BranchAdmittanceMatrix secondOpenLeg) {
        Complex ysh1 = LinkData.kronAntenna(firstOpenLeg.y11(), firstOpenLeg.y12(), firstOpenLeg.y21(), firstOpenLeg.y22(), true);
        Complex ysh2 = LinkData.kronAntenna(secondOpenLeg.y11(), secondOpenLeg.y12(), secondOpenLeg.y21(), secondOpenLeg.y22(), true);
        Complex y22 = closeLeg.y22().add(ysh1).add(ysh2);
        return LinkData.kronAntenna(closeLeg.y11(), closeLeg.y12(), closeLeg.y21(), y22, false);
    }

    private static double getV(ThreeWindingsTransformer.Leg leg) {
        return leg.getTerminal().isConnected() ? leg.getTerminal().getBusView().getBus().getV() : Double.NaN;
    }

    private static double getTheta(ThreeWindingsTransformer.Leg leg) {
        return leg.getTerminal().isConnected() ? Math.toRadians(leg.getTerminal().getBusView().getBus().getAngle()) : Double.NaN;
    }

    private static double rho(ThreeWindingsTransformer.Leg leg, double ratedU0) {
        double rho = ratedU0 / leg.getRatedU();
        rho *= leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getRho()).orElse(1.0).doubleValue();
        return rho *= leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getRho()).orElse(1.0).doubleValue();
    }

    private static double alpha(ThreeWindingsTransformer.Leg leg) {
        return leg.getOptionalPhaseTapChanger().map(ptc -> Math.toRadians(((PhaseTapChangerStep)ptc.getCurrentStep()).getAlpha())).orElse(0.0);
    }

    private static double getValue(double initialValue, double rtcStepValue, double ptcStepValue) {
        return initialValue * (1.0 + rtcStepValue / 100.0) * (1.0 + ptcStepValue / 100.0);
    }

    private static double getR(ThreeWindingsTransformer.Leg leg) {
        return TwtData.getValue(leg.getR(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getR()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getR()).orElse(0.0));
    }

    private static double getX(ThreeWindingsTransformer.Leg leg) {
        return TwtData.getValue(leg.getX(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getX()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getX()).orElse(0.0));
    }

    private static double getG1(ThreeWindingsTransformer.Leg leg, boolean twtSplitShuntAdmittance) {
        return TwtData.getValue(twtSplitShuntAdmittance ? leg.getG() / 2.0 : leg.getG(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getG()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getG()).orElse(0.0));
    }

    private static double getB1(ThreeWindingsTransformer.Leg leg, boolean twtSplitShuntAdmittance) {
        return TwtData.getValue(twtSplitShuntAdmittance ? leg.getB() / 2.0 : leg.getB(), leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getB()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getB()).orElse(0.0));
    }

    private static double getG2(ThreeWindingsTransformer.Leg leg, boolean twtSplitShuntAdmittance) {
        return TwtData.getValue(twtSplitShuntAdmittance ? leg.getG() / 2.0 : 0.0, leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getG()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getG()).orElse(0.0));
    }

    private static double getB2(ThreeWindingsTransformer.Leg leg, boolean twtSplitShuntAdmittance) {
        return TwtData.getValue(twtSplitShuntAdmittance ? leg.getB() / 2.0 : 0.0, leg.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getB()).orElse(0.0), leg.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getB()).orElse(0.0));
    }

    private static boolean isMainComponent(ThreeWindingsTransformer.Leg leg) {
        Bus bus = leg.getTerminal().getBusView().getBus();
        Bus connectableBus = leg.getTerminal().getBusView().getConnectableBus();
        boolean connectableMainComponent = connectableBus != null && connectableBus.isInMainConnectedComponent();
        return bus != null ? bus.isInMainConnectedComponent() : connectableMainComponent;
    }

    private static boolean valid(double voltage, double theta) {
        if (Double.isNaN(voltage) || voltage <= 0.0) {
            return false;
        }
        return !Double.isNaN(theta);
    }

    public String getId() {
        return this.id;
    }

    public double getComputedP(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.computedP1;
            case ThreeSides.TWO -> this.computedP2;
            case ThreeSides.THREE -> this.computedP3;
        };
    }

    public double getComputedQ(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.computedQ1;
            case ThreeSides.TWO -> this.computedQ2;
            case ThreeSides.THREE -> this.computedQ3;
        };
    }

    public double getP(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.p1;
            case ThreeSides.TWO -> this.p2;
            case ThreeSides.THREE -> this.p3;
        };
    }

    public double getQ(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.q1;
            case ThreeSides.TWO -> this.q2;
            case ThreeSides.THREE -> this.q3;
        };
    }

    public double getU(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.u1;
            case ThreeSides.TWO -> this.u2;
            case ThreeSides.THREE -> this.u3;
        };
    }

    public double getStarU() {
        return this.starU;
    }

    public double getTheta(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.theta1;
            case ThreeSides.TWO -> this.theta2;
            case ThreeSides.THREE -> this.theta3;
        };
    }

    public double getStarTheta() {
        return this.starTheta;
    }

    public double getR(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.r1;
            case ThreeSides.TWO -> this.r2;
            case ThreeSides.THREE -> this.r3;
        };
    }

    public double getX(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.x1;
            case ThreeSides.TWO -> this.x2;
            case ThreeSides.THREE -> this.x3;
        };
    }

    public double getG1(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.g11;
            case ThreeSides.TWO -> this.g21;
            case ThreeSides.THREE -> this.g31;
        };
    }

    public double getB1(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.b11;
            case ThreeSides.TWO -> this.b21;
            case ThreeSides.THREE -> this.b31;
        };
    }

    public double getG2(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.g12;
            case ThreeSides.TWO -> this.g22;
            case ThreeSides.THREE -> this.g32;
        };
    }

    public double getB2(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.b12;
            case ThreeSides.TWO -> this.b22;
            case ThreeSides.THREE -> this.b32;
        };
    }

    public double getRatedU(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.ratedU1;
            case ThreeSides.TWO -> this.ratedU2;
            case ThreeSides.THREE -> this.ratedU3;
        };
    }

    public boolean isConnected(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.connected1;
            case ThreeSides.TWO -> this.connected2;
            case ThreeSides.THREE -> this.connected3;
        };
    }

    public boolean isMainComponent(ThreeSides side) {
        Objects.requireNonNull(side);
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> this.mainComponent1;
            case ThreeSides.TWO -> this.mainComponent2;
            case ThreeSides.THREE -> this.mainComponent3;
        };
    }

    public int getPhaseAngleClock2() {
        return this.phaseAngleClock2;
    }

    public int getPhaseAngleClock3() {
        return this.phaseAngleClock3;
    }

    public double getRatedU0() {
        return this.ratedU0;
    }
}

