/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.util.LoadingLimitsUtil;
import java.util.Collection;
import java.util.Optional;

public interface FlowsLimitsHolder {
    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups();

    public Optional<String> getSelectedOperationalLimitsGroupId();

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup(String var1);

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup();

    public OperationalLimitsGroup newOperationalLimitsGroup(String var1);

    public void setSelectedOperationalLimitsGroup(String var1);

    public void removeOperationalLimitsGroup(String var1);

    public void cancelSelectedOperationalLimitsGroup();

    default public Optional<CurrentLimits> getCurrentLimits() {
        return this.getSelectedOperationalLimitsGroup().flatMap(OperationalLimitsGroup::getCurrentLimits);
    }

    default public CurrentLimits getNullableCurrentLimits() {
        return this.getCurrentLimits().orElse(null);
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits() {
        return this.getSelectedOperationalLimitsGroup().flatMap(OperationalLimitsGroup::getActivePowerLimits);
    }

    default public ActivePowerLimits getNullableActivePowerLimits() {
        return this.getActivePowerLimits().orElse(null);
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits() {
        return this.getSelectedOperationalLimitsGroup().flatMap(OperationalLimitsGroup::getApparentPowerLimits);
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits() {
        return this.getApparentPowerLimits().orElse(null);
    }

    public CurrentLimitsAdder newCurrentLimits();

    default public CurrentLimitsAdder newCurrentLimits(CurrentLimits limits) {
        CurrentLimitsAdder adder = this.newCurrentLimits();
        return LoadingLimitsUtil.initializeFromLoadingLimits(adder, limits);
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits();

    default public ApparentPowerLimitsAdder newApparentPowerLimits(ApparentPowerLimits limits) {
        ApparentPowerLimitsAdder adder = this.newApparentPowerLimits();
        return LoadingLimitsUtil.initializeFromLoadingLimits(adder, limits);
    }

    public ActivePowerLimitsAdder newActivePowerLimits();

    default public ActivePowerLimitsAdder newActivePowerLimits(ActivePowerLimits limits) {
        ActivePowerLimitsAdder adder = this.newActivePowerLimits();
        return LoadingLimitsUtil.initializeFromLoadingLimits(adder, limits);
    }
}

