/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.ImportPostProcessor;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.ImportersServiceLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface Importer {
    public static Collection<String> getFormats(ImportersLoader loader) {
        Objects.requireNonNull(loader);
        return loader.loadImporters().stream().map(Importer::getFormat).collect(Collectors.toSet());
    }

    public static Collection<String> getFormats() {
        return Importer.getFormats(new ImportersServiceLoader());
    }

    private static Importer wrapImporter(ImportersLoader loader, Importer importer, ComputationManager computationManager, ImportConfig config) {
        Objects.requireNonNull(computationManager);
        Objects.requireNonNull(config);
        List<String> postProcessorNames = config.getPostProcessors();
        if (postProcessorNames != null && !postProcessorNames.isEmpty()) {
            return new ImporterWrapper(loader, importer, computationManager, postProcessorNames);
        }
        return importer;
    }

    public static Collection<Importer> list(ImportersLoader loader, ComputationManager computationManager, ImportConfig config) {
        Objects.requireNonNull(loader);
        return loader.loadImporters().stream().map(importer -> Importer.wrapImporter(loader, importer, computationManager, config)).collect(Collectors.toList());
    }

    public static Collection<Importer> list(ComputationManager computationManager, ImportConfig config) {
        return Importer.list(new ImportersServiceLoader(), computationManager, config);
    }

    public static Collection<Importer> list() {
        return Importer.list(LocalComputationManager.getDefault(), ImportConfig.CACHE.get());
    }

    public static Importer find(ImportersLoader loader, String format, @Nullable ComputationManager computationManager, ImportConfig config) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(loader);
        for (Importer importer : loader.loadImporters()) {
            if (!format.equals(importer.getFormat())) continue;
            return Importer.wrapImporter(loader, importer, computationManager, config);
        }
        return null;
    }

    public static Importer find(String format, @Nullable ComputationManager computationManager, ImportConfig config) {
        return Importer.find(new ImportersServiceLoader(), format, computationManager, config);
    }

    public static Importer find(String format, @Nullable ComputationManager computationManager) {
        return Importer.find(format, computationManager, ImportConfig.CACHE.get());
    }

    public static Importer find(String format) {
        return Importer.find(format, LocalComputationManager.getDefault());
    }

    public static Collection<String> getPostProcessorNames(ImportersLoader loader) {
        Objects.requireNonNull(loader);
        return loader.loadPostProcessors().stream().map(ImportPostProcessor::getName).collect(Collectors.toList());
    }

    public static Collection<String> getPostProcessorNames() {
        return Importer.getPostProcessorNames(new ImportersServiceLoader());
    }

    public static Importer addPostProcessors(ImportersLoader loader, Importer importer, ComputationManager computationManager, String ... names) {
        return new ImporterWrapper(loader, importer, computationManager, Arrays.asList(names));
    }

    public static Importer addPostProcessors(Importer importer, ComputationManager computationManager, String ... names) {
        return Importer.addPostProcessors(new ImportersServiceLoader(), importer, computationManager, names);
    }

    public static Importer addPostProcessors(Importer importer, String ... names) {
        return Importer.addPostProcessors(importer, LocalComputationManager.getDefault(), names);
    }

    public static Importer setPostProcessors(ImportersLoader loader, Importer importer, ComputationManager computationManager, String ... names) {
        Importer importer2 = Importer.removePostProcessors(importer);
        return Importer.addPostProcessors(loader, importer2, computationManager, names);
    }

    public static Importer setPostProcessors(Importer importer, ComputationManager computationManager, String ... names) {
        return Importer.setPostProcessors(new ImportersServiceLoader(), importer, computationManager, names);
    }

    public static Importer setPostProcessors(Importer importer, String ... names) {
        return Importer.setPostProcessors(importer, LocalComputationManager.getDefault(), names);
    }

    public static Importer removePostProcessors(Importer importer) {
        Objects.requireNonNull(importer);
        if (importer instanceof ImporterWrapper) {
            ImporterWrapper importerWrapper = (ImporterWrapper)importer;
            return Importer.removePostProcessors(importerWrapper.getImporter());
        }
        return importer;
    }

    public static Importer find(ReadOnlyDataSource dataSource, ImportersLoader loader, ComputationManager computationManager, ImportConfig config) {
        for (Importer importer : Importer.list(loader, computationManager, config)) {
            if (!importer.exists(dataSource)) continue;
            return importer;
        }
        return null;
    }

    public static Importer find(ReadOnlyDataSource dataSource, ComputationManager computationManager) {
        return Importer.find(dataSource, new ImportersServiceLoader(), computationManager, ImportConfig.CACHE.get());
    }

    public static Importer find(ReadOnlyDataSource dataSource) {
        return Importer.find(dataSource, LocalComputationManager.getDefault());
    }

    public String getFormat();

    default public List<String> getSupportedExtensions() {
        return Collections.emptyList();
    }

    default public List<Parameter> getParameters() {
        return Collections.emptyList();
    }

    public String getComment();

    public boolean exists(ReadOnlyDataSource var1);

    @Deprecated(since="2.6.0")
    default public Network importData(ReadOnlyDataSource dataSource, Properties parameters) {
        return this.importData(dataSource, NetworkFactory.findDefault(), parameters);
    }

    default public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters) {
        return this.importData(dataSource, networkFactory, parameters, ReportNode.NO_OP);
    }

    default public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters, ReportNode reportNode) {
        return this.importData(dataSource, networkFactory, parameters);
    }

    default public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
        throw new UnsupportedOperationException("Copy not implemented");
    }

    public static class ImporterWrapper
    implements Importer {
        private final Importer importer;
        private final ComputationManager computationManager;
        private final List<String> names;
        private final ImportersLoader loader;

        ImporterWrapper(ImportersLoader loader, Importer importer, ComputationManager computationManager, List<String> names) {
            this.loader = Objects.requireNonNull(loader);
            this.importer = importer;
            this.computationManager = computationManager;
            this.names = names;
        }

        public Importer getImporter() {
            return this.importer;
        }

        @Override
        public String getFormat() {
            return this.importer.getFormat();
        }

        @Override
        public List<String> getSupportedExtensions() {
            return this.importer.getSupportedExtensions();
        }

        @Override
        public List<Parameter> getParameters() {
            return this.importer.getParameters();
        }

        @Override
        public String getComment() {
            return this.importer.getComment();
        }

        @Override
        public boolean exists(ReadOnlyDataSource dataSource) {
            return this.importer.exists(dataSource);
        }

        private static ImportPostProcessor getPostProcessor(ImportersLoader loader, String name) {
            for (ImportPostProcessor ipp : loader.loadPostProcessors()) {
                if (!ipp.getName().equals(name)) continue;
                return ipp;
            }
            throw new PowsyblException("Post processor " + name + " not found");
        }

        @Override
        public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters, ReportNode reportNode) {
            Network network = this.importer.importData(dataSource, networkFactory, parameters, reportNode);
            for (String name : this.names) {
                try {
                    ImporterWrapper.getPostProcessor(this.loader, name).process(network, this.computationManager, reportNode);
                }
                catch (Exception e) {
                    throw new PowsyblException((Throwable)e);
                }
            }
            return network;
        }

        @Override
        public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters) {
            return this.importData(dataSource, networkFactory, parameters, ReportNode.NO_OP);
        }

        @Override
        public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
            this.importer.copy(fromDataSource, toDataSource);
        }
    }
}

