/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.identifiers;

import com.google.common.collect.ImmutableList;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class NetworkElementIdentifierContingencyList
implements NetworkElementIdentifier {
    private final List<NetworkElementIdentifier> networkElementIdentifiers;
    private final String contingencyId;

    public List<NetworkElementIdentifier> getNetworkElementIdentifiers() {
        return this.networkElementIdentifiers;
    }

    public NetworkElementIdentifierContingencyList(List<NetworkElementIdentifier> networkElementIdentifiers) {
        this(networkElementIdentifiers, null);
    }

    public NetworkElementIdentifierContingencyList(List<NetworkElementIdentifier> networkElementIdentifiers, String contingencyId) {
        this.networkElementIdentifiers = ImmutableList.copyOf(networkElementIdentifiers);
        this.contingencyId = contingencyId;
    }

    @Override
    public Set<Identifiable> filterIdentifiable(Network network) {
        LinkedHashSet<Identifiable> identifiables = new LinkedHashSet<Identifiable>();
        this.networkElementIdentifiers.forEach(identifiant -> identifiables.addAll(identifiant.filterIdentifiable(network)));
        return identifiables;
    }

    @Override
    public Set<String> getNotFoundElements(Network network) {
        LinkedHashSet<String> notFoundElements = new LinkedHashSet<String>();
        this.networkElementIdentifiers.forEach(identifiant -> notFoundElements.addAll(identifiant.getNotFoundElements(network)));
        return notFoundElements;
    }

    @Override
    public NetworkElementIdentifier.IdentifierType getType() {
        return NetworkElementIdentifier.IdentifierType.LIST;
    }

    @Override
    public Optional<String> getContingencyId() {
        return Optional.ofNullable(this.contingencyId);
    }
}

