/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.TieLine;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DanglingLine
extends Injection<DanglingLine>,
FlowsLimitsHolder {
    public static final Logger LOG = LoggerFactory.getLogger(DanglingLine.class);

    public boolean isPaired();

    public double getP0();

    public DanglingLine setP0(double var1);

    public double getQ0();

    public DanglingLine setQ0(double var1);

    public double getR();

    public DanglingLine setR(double var1);

    public double getX();

    public DanglingLine setX(double var1);

    public double getG();

    public DanglingLine setG(double var1);

    public double getB();

    public DanglingLine setB(double var1);

    default public Generation getGeneration() {
        return null;
    }

    public String getPairingKey();

    public DanglingLine setPairingKey(String var1);

    public Boundary getBoundary();

    default public Optional<TieLine> getTieLine() {
        return Optional.empty();
    }

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.DANGLING_LINE;
    }

    default public void applySolvedValues() {
        this.setGenerationTargetPToP();
        this.setGenerationTargetQToQ();
        this.setGenerationTargetVToV();
    }

    default public void setGenerationTargetPToP() {
        double p;
        if (this.getGeneration() != null && !Double.isNaN(p = this.getTerminal().getP())) {
            this.getGeneration().setTargetP(-p);
        }
    }

    default public void setGenerationTargetQToQ() {
        double q;
        if (this.getGeneration() != null && !Double.isNaN(q = this.getTerminal().getQ())) {
            this.getGeneration().setTargetQ(-q);
        }
    }

    default public void setGenerationTargetVToV() {
        Bus bus;
        if (this.getGeneration() != null && (bus = this.getTerminal().getBusView().getBus()) != null && !Double.isNaN(bus.getV())) {
            this.getGeneration().setTargetV(bus.getV());
        }
    }

    public static interface Generation
    extends ReactiveLimitsHolder {
        public double getTargetP();

        public Generation setTargetP(double var1);

        public double getMaxP();

        public Generation setMaxP(double var1);

        public double getMinP();

        public Generation setMinP(double var1);

        public double getTargetQ();

        public Generation setTargetQ(double var1);

        public boolean isVoltageRegulationOn();

        public Generation setVoltageRegulationOn(boolean var1);

        public double getTargetV();

        public Generation setTargetV(double var1);
    }
}

