/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.PropertiesHolder;
import com.powsybl.iidm.network.util.LoadingLimitsUtil;
import java.util.Optional;

public interface OperationalLimitsGroup
extends PropertiesHolder {
    public String getId();

    public Optional<CurrentLimits> getCurrentLimits();

    public Optional<ActivePowerLimits> getActivePowerLimits();

    public Optional<ApparentPowerLimits> getApparentPowerLimits();

    public CurrentLimitsAdder newCurrentLimits();

    public ActivePowerLimitsAdder newActivePowerLimits();

    public ApparentPowerLimitsAdder newApparentPowerLimits();

    default public CurrentLimitsAdder newCurrentLimits(CurrentLimits currentLimits) {
        CurrentLimitsAdder currentLimitsAdder = this.newCurrentLimits();
        return LoadingLimitsUtil.initializeFromLoadingLimits(currentLimitsAdder, currentLimits);
    }

    default public ActivePowerLimitsAdder newActivePowerLimits(ActivePowerLimits activePowerLimits) {
        ActivePowerLimitsAdder activePowerLimitsAdder = this.newActivePowerLimits();
        return LoadingLimitsUtil.initializeFromLoadingLimits(activePowerLimitsAdder, activePowerLimits);
    }

    default public ApparentPowerLimitsAdder newApparentPowerLimits(ApparentPowerLimits apparentPowerLimits) {
        ApparentPowerLimitsAdder apparentPowerLimitsAdder = this.newApparentPowerLimits();
        return LoadingLimitsUtil.initializeFromLoadingLimits(apparentPowerLimitsAdder, apparentPowerLimits);
    }

    public void removeCurrentLimits();

    public void removeActivePowerLimits();

    public void removeApparentPowerLimits();

    public boolean isEmpty();
}

