/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.identifiers;

import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SubstationOrVoltageLevelEquipmentsIdentifier
implements NetworkElementIdentifier {
    private final String substationOrVoltageLevelId;
    private final Set<IdentifiableType> voltageLevelIdentifiableTypes;

    public SubstationOrVoltageLevelEquipmentsIdentifier(String substationOrVoltageLevelId) {
        this(substationOrVoltageLevelId, Set.of());
    }

    public SubstationOrVoltageLevelEquipmentsIdentifier(String substationOrVoltageLevelId, Set<IdentifiableType> voltageLevelIdentifiableTypes) {
        this.substationOrVoltageLevelId = substationOrVoltageLevelId;
        this.voltageLevelIdentifiableTypes = voltageLevelIdentifiableTypes;
    }

    public String getSubstationOrVoltageLevelId() {
        return this.substationOrVoltageLevelId;
    }

    public Set<IdentifiableType> getVoltageLevelIdentifiableTypes() {
        return this.voltageLevelIdentifiableTypes;
    }

    @Override
    public Set<Identifiable> filterIdentifiable(Network network) {
        Stream<Connectable<Object>> connectableStream;
        VoltageLevel voltageLevel = network.getVoltageLevel(this.substationOrVoltageLevelId);
        Substation substation = network.getSubstation(this.substationOrVoltageLevelId);
        if (voltageLevel != null) {
            connectableStream = voltageLevel.getConnectableStream();
        } else if (substation != null) {
            connectableStream = substation.getVoltageLevelStream().flatMap(VoltageLevel::getConnectableStream);
        } else {
            return Set.of();
        }
        if (this.voltageLevelIdentifiableTypes.isEmpty()) {
            return connectableStream.collect(Collectors.toSet());
        }
        return connectableStream.filter(connectable -> this.voltageLevelIdentifiableTypes.contains((Object)connectable.getType())).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getNotFoundElements(Network network) {
        VoltageLevel voltageLevel = network.getVoltageLevel(this.substationOrVoltageLevelId);
        Substation substation = network.getSubstation(this.substationOrVoltageLevelId);
        if (voltageLevel == null && substation == null) {
            return Set.of(this.substationOrVoltageLevelId);
        }
        return Set.of();
    }

    @Override
    public NetworkElementIdentifier.IdentifierType getType() {
        return NetworkElementIdentifier.IdentifierType.SUBSTATION_OR_VOLTAGE_LEVEL_EQUIPMENTS;
    }

    @Override
    public Optional<String> getContingencyId() {
        return Optional.ofNullable(this.substationOrVoltageLevelId);
    }

    @Override
    public boolean isMonoElementContingencies() {
        return true;
    }
}

