/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.identifiers.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.iidm.network.identifiers.IdBasedNetworkElementIdentifier;
import com.powsybl.iidm.network.identifiers.IdWithWildcardsNetworkElementIdentifier;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifierContingencyList;
import com.powsybl.iidm.network.identifiers.SubstationOrVoltageLevelEquipmentsIdentifier;
import com.powsybl.iidm.network.identifiers.VoltageLevelAndOrderNetworkElementIdentifier;
import java.io.IOException;
import java.util.Optional;

public class IdentifierSerializer
extends StdSerializer<NetworkElementIdentifier> {
    public IdentifierSerializer() {
        super(NetworkElementIdentifier.class);
    }

    public void serialize(NetworkElementIdentifier networkElementIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", networkElementIdentifier.getType().toString());
        Optional<String> optionalContingencyId = networkElementIdentifier.getContingencyId();
        if (optionalContingencyId.isPresent()) {
            jsonGenerator.writeStringField("contingencyId", optionalContingencyId.get());
        }
        switch (networkElementIdentifier.getType()) {
            case ID_BASED: {
                jsonGenerator.writeStringField("identifier", ((IdBasedNetworkElementIdentifier)networkElementIdentifier).getIdentifier());
                break;
            }
            case LIST: {
                serializerProvider.defaultSerializeField("identifierList", ((NetworkElementIdentifierContingencyList)networkElementIdentifier).getNetworkElementIdentifiers(), jsonGenerator);
                break;
            }
            case VOLTAGE_LEVELS_AND_ORDER: {
                VoltageLevelAndOrderNetworkElementIdentifier ucteIdentifier = (VoltageLevelAndOrderNetworkElementIdentifier)networkElementIdentifier;
                jsonGenerator.writeStringField("voltageLevelId1", ucteIdentifier.getVoltageLevelId1());
                jsonGenerator.writeStringField("voltageLevelId2", ucteIdentifier.getVoltageLevelId2());
                jsonGenerator.writeStringField("order", Character.toString(ucteIdentifier.getOrder()));
                break;
            }
            case ID_WITH_WILDCARDS: {
                IdWithWildcardsNetworkElementIdentifier identifier = (IdWithWildcardsNetworkElementIdentifier)networkElementIdentifier;
                jsonGenerator.writeStringField("identifier", identifier.getIdentifier());
                jsonGenerator.writeStringField("wildcard", identifier.getWildcardCharacter());
                break;
            }
            case SUBSTATION_OR_VOLTAGE_LEVEL_EQUIPMENTS: {
                SubstationOrVoltageLevelEquipmentsIdentifier substIdentifier = (SubstationOrVoltageLevelEquipmentsIdentifier)networkElementIdentifier;
                jsonGenerator.writeStringField("substationOrVoltageLevelId", substIdentifier.getSubstationOrVoltageLevelId());
                serializerProvider.defaultSerializeField("voltageLevelIdentifiableTypes", substIdentifier.getVoltageLevelIdentifiableTypes(), jsonGenerator);
            }
        }
        jsonGenerator.writeEndObject();
    }
}

