/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.limitmodification;

import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.limitmodification.LimitsComputer;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractLimitsComputerWithCache<P, L>
implements LimitsComputer<P, L> {
    private final Map<CacheKey<P>, LimitsContainer<L>> reducedLimitsCache = new HashMap<CacheKey<P>, LimitsContainer<L>>();

    protected AbstractLimitsComputerWithCache() {
    }

    @Override
    public Optional<LimitsContainer<L>> computeLimits(P processable, LimitType limitType, ThreeSides side, boolean monitoringOnly) {
        Objects.requireNonNull(processable);
        CacheKey<P> cacheKey = new CacheKey<P>(processable, limitType, side, monitoringOnly);
        if (this.reducedLimitsCache.containsKey(cacheKey)) {
            return Optional.of(this.reducedLimitsCache.get(cacheKey));
        }
        return this.computeUncachedLimits(processable, limitType, side, monitoringOnly);
    }

    protected abstract Optional<LimitsContainer<L>> computeUncachedLimits(P var1, LimitType var2, ThreeSides var3, boolean var4);

    protected void putInCache(P processable, LimitType limitType, ThreeSides side, boolean monitoringOnly, LimitsContainer<L> limitsContainer) {
        this.reducedLimitsCache.put(new CacheKey<P>(processable, limitType, side, monitoringOnly), limitsContainer);
    }

    public void clearCache() {
        this.reducedLimitsCache.clear();
    }

    private record CacheKey<P>(P processable, LimitType type, ThreeSides side, boolean monitoringOnly) {
    }
}

