/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.util.LinkData;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class DanglingLineData {
    private final DanglingLine danglingLine;
    private final double boundaryBusU;
    private final double boundaryBusTheta;

    public DanglingLineData(DanglingLine danglingLine) {
        this.danglingLine = Objects.requireNonNull(danglingLine);
        double u1 = DanglingLineData.getV(danglingLine);
        double theta1 = DanglingLineData.getTheta(danglingLine);
        if (!DanglingLineData.valid(u1, theta1)) {
            this.boundaryBusU = Double.NaN;
            this.boundaryBusTheta = Double.NaN;
            return;
        }
        if (DanglingLineData.zeroImpedance(danglingLine)) {
            this.boundaryBusU = u1;
            this.boundaryBusTheta = theta1;
            return;
        }
        Complex v1 = ComplexUtils.polar2Complex((double)u1, (double)theta1);
        Complex vBoundaryBus = new Complex(Double.NaN, Double.NaN);
        if (danglingLine.getP0() == 0.0 && danglingLine.getQ0() == 0.0) {
            LinkData.BranchAdmittanceMatrix adm = LinkData.calculateBranchAdmittance(danglingLine.getR(), danglingLine.getX(), 1.0, 0.0, 1.0, 0.0, new Complex(danglingLine.getG(), danglingLine.getB()), new Complex(0.0, 0.0));
            vBoundaryBus = adm.y21().multiply(v1).negate().divide(adm.y22());
        } else {
            Complex sBoundary = new Complex(-danglingLine.getP0(), -danglingLine.getQ0());
            Complex zt = new Complex(danglingLine.getR(), danglingLine.getX());
            double v12 = v1.abs() * v1.abs();
            Complex sigma = zt.multiply(sBoundary.conjugate()).multiply(1.0 / v12);
            double d = 0.25 + sigma.getReal() - sigma.getImaginary() * sigma.getImaginary();
            if (d >= 0.0) {
                vBoundaryBus = new Complex(0.5 + Math.sqrt(d), sigma.getImaginary()).multiply(v1);
            }
        }
        this.boundaryBusU = vBoundaryBus.abs();
        this.boundaryBusTheta = vBoundaryBus.getArgument();
    }

    static double getV(DanglingLine danglingLine) {
        return danglingLine.getTerminal().isConnected() ? danglingLine.getTerminal().getBusView().getBus().getV() : Double.NaN;
    }

    static double getTheta(DanglingLine danglingLine) {
        return danglingLine.getTerminal().isConnected() ? Math.toRadians(danglingLine.getTerminal().getBusView().getBus().getAngle()) : Double.NaN;
    }

    private static boolean valid(double v, double theta) {
        if (Double.isNaN(v) || v <= 0.0) {
            return false;
        }
        return !Double.isNaN(theta);
    }

    public String getId() {
        return this.danglingLine.getId();
    }

    public double getBoundaryBusU() {
        return this.boundaryBusU;
    }

    public double getBoundaryBusTheta() {
        return this.boundaryBusTheta;
    }

    public static boolean zeroImpedance(DanglingLine parent) {
        return parent.getR() == 0.0 && parent.getX() == 0.0;
    }
}

