/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PropertiesHolder;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface Identifiable<I extends Identifiable<I>>
extends Extendable<I>,
PropertiesHolder {
    @Override
    public Network getNetwork();

    default public Network getParentNetwork() {
        return this.getNetwork();
    }

    public String getId();

    default public Set<String> getAliases() {
        return Collections.emptySet();
    }

    default public Optional<String> getAliasFromType(String aliasType) {
        return Optional.empty();
    }

    default public Optional<String> getAliasType(String alias) {
        return Optional.empty();
    }

    default public void addAlias(String alias) {
    }

    default public void addAlias(String alias, boolean ensureAliasUnicity) {
        this.addAlias(alias);
    }

    default public void addAlias(String alias, String aliasType) {
    }

    default public void addAlias(String alias, String aliasType, boolean ensureAliasUnicity) {
        this.addAlias(alias, aliasType);
    }

    default public void removeAlias(String alias) {
    }

    default public boolean hasAliases() {
        return false;
    }

    default public Optional<String> getOptionalName() {
        throw new UnsupportedOperationException();
    }

    default public String getNameOrId() {
        return this.getOptionalName().orElseGet(this::getId);
    }

    default public I setName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public boolean isFictitious() {
        return false;
    }

    default public void setFictitious(boolean fictitious) {
        throw new UnsupportedOperationException();
    }

    public IdentifiableType getType();
}

