/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.DirectoryDataSource;
import com.powsybl.commons.datasource.MultipleReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyMemDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Container;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.DcConnectable;
import com.powsybl.iidm.network.DcGround;
import com.powsybl.iidm.network.DcGroundAdder;
import com.powsybl.iidm.network.DcLine;
import com.powsybl.iidm.network.DcLineAdder;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcNodeAdder;
import com.powsybl.iidm.network.DcSwitch;
import com.powsybl.iidm.network.DcSwitchAdder;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Exporters;
import com.powsybl.iidm.network.ExportersLoader;
import com.powsybl.iidm.network.ExportersServiceLoader;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Ground;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.Importers;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.ImportersServiceLoader;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LineCommutatedConverter;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.ReportNodeContext;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VariantManager;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageAngleLimitAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VoltageSourceConverter;
import com.powsybl.iidm.network.VscConverterStation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Network
extends Container<Network> {
    default public Collection<Network> getSubnetworks() {
        return Collections.emptyList();
    }

    default public Network getSubnetwork(String id) {
        return null;
    }

    public static Network read(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters, NetworkFactory networkFactory, ImportersLoader loader, ReportNode reportNode) {
        DataSource dataSource = DataSource.fromPath((Path)file);
        Importer importer = Importer.find((ReadOnlyDataSource)dataSource, loader, computationManager, config);
        if (importer != null) {
            return importer.importData((ReadOnlyDataSource)dataSource, networkFactory, parameters, reportNode);
        }
        throw new PowsyblException("Unsupported file format or invalid file.");
    }

    public static Network read(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader, ReportNode reportNode) {
        return Network.read(file, computationManager, config, parameters, NetworkFactory.findDefault(), loader, reportNode);
    }

    public static Network read(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader) {
        return Network.read(file, computationManager, config, parameters, loader, ReportNode.NO_OP);
    }

    public static Network read(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters) {
        return Network.read(file, computationManager, config, parameters, new ImportersServiceLoader());
    }

    public static Network read(Path file) {
        return Network.read(file, LocalComputationManager.getDefault(), ImportConfig.CACHE.get(), null);
    }

    public static Network read(String file) {
        return Network.read(Paths.get(file, new String[0]));
    }

    public static Network read(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters, NetworkFactory networkFactory, ImportersLoader loader, ReportNode reportNode) {
        ReadOnlyMemDataSource dataSource = new ReadOnlyMemDataSource(DataSourceUtil.getBaseName((String)filename));
        dataSource.putData(filename, data);
        Importer importer = Importer.find((ReadOnlyDataSource)dataSource, loader, computationManager, config);
        if (importer != null) {
            return importer.importData((ReadOnlyDataSource)dataSource, networkFactory, parameters, reportNode);
        }
        throw new PowsyblException("Unsupported file format or invalid file.");
    }

    public static Network read(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader, ReportNode reportNode) {
        return Network.read(filename, data, computationManager, config, parameters, NetworkFactory.findDefault(), loader, reportNode);
    }

    public static Network read(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader) {
        return Network.read(filename, data, computationManager, config, parameters, loader, ReportNode.NO_OP);
    }

    public static Network read(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters) {
        return Network.read(filename, data, computationManager, config, parameters, new ImportersServiceLoader());
    }

    public static Network read(String filename, InputStream data, ComputationManager computationManager) {
        return Network.read(filename, data, computationManager, ImportConfig.CACHE.get(), null);
    }

    public static Network read(String filename, InputStream data) {
        return Network.read(filename, data, LocalComputationManager.getDefault());
    }

    public static Network read(String filename, InputStream data, ReportNode reportNode) {
        return Network.read(filename, data, LocalComputationManager.getDefault(), ImportConfig.CACHE.get(), null, (ImportersLoader)new ImportersServiceLoader(), reportNode);
    }

    public static Network read(ReadOnlyDataSource dataSource) {
        return Network.read(dataSource, null);
    }

    public static Network read(ReadOnlyDataSource dataSource, Properties properties) {
        return Network.read(dataSource, properties, ReportNode.NO_OP);
    }

    public static Network read(ReadOnlyDataSource dataSource, Properties parameters, ReportNode reportNode) {
        return Network.read(dataSource, LocalComputationManager.getDefault(), ImportConfig.load(), parameters, NetworkFactory.findDefault(), (ImportersLoader)new ImportersServiceLoader(), reportNode);
    }

    public static Network read(ReadOnlyDataSource dataSource, ComputationManager computationManager, ImportConfig config, Properties parameters, NetworkFactory networkFactory, ImportersLoader loader, ReportNode reportNode) {
        Importer importer = Importer.find(dataSource, loader, computationManager, config);
        if (importer != null) {
            return importer.importData(dataSource, networkFactory, parameters, reportNode);
        }
        throw new PowsyblException("Unsupported file format or invalid file.");
    }

    public static Network read(ReadOnlyDataSource ... dataSources) {
        return Network.read(List.of(dataSources));
    }

    public static Network read(Path ... files) {
        List<ReadOnlyDataSource> dataSources = Arrays.stream(Objects.requireNonNull(files)).map(DataSource::fromPath).collect(Collectors.toList());
        return Network.read(dataSources);
    }

    public static Network read(List<ReadOnlyDataSource> dataSources) {
        return Network.read(dataSources, null);
    }

    public static Network read(List<ReadOnlyDataSource> dataSources, Properties properties) {
        return Network.read(dataSources, properties, ReportNode.NO_OP);
    }

    public static Network read(List<ReadOnlyDataSource> dataSources, Properties properties, ReportNode reportNode) {
        Objects.requireNonNull(dataSources);
        return Network.read((ReadOnlyDataSource)new MultipleReadOnlyDataSource(dataSources), properties, reportNode);
    }

    public static void readAll(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, NetworkFactory networkFactory, ReportNode reportNode) throws IOException, InterruptedException, ExecutionException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new PowsyblException("Directory " + dir + " does not exist or is not a regular directory");
        }
        for (Importer importer : Importer.list(loader, computationManager, config)) {
            Importers.importAll(dir, importer, parallel, parameters, consumer, listener, networkFactory, reportNode);
        }
    }

    public static void readAll(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, ReportNode reportNode) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, loader, computationManager, config, parameters, consumer, listener, NetworkFactory.findDefault(), reportNode);
    }

    public static void readAll(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, loader, computationManager, config, parameters, consumer, listener, ReportNode.NO_OP);
    }

    public static void readAll(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, loader, computationManager, config, null, consumer, listener);
    }

    public static void readAll(Path dir, boolean parallel, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, new ImportersServiceLoader(), computationManager, config, parameters, consumer, listener);
    }

    public static void readAll(Path dir, boolean parallel, ComputationManager computationManager, ImportConfig config, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, new ImportersServiceLoader(), computationManager, config, consumer, listener);
    }

    public static void readAll(Path dir, boolean parallel, ComputationManager computationManager, ImportConfig config, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, computationManager, config, consumer, null);
    }

    public static void readAll(Path dir, boolean parallel, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, LocalComputationManager.getDefault(), ImportConfig.CACHE.get(), consumer);
    }

    public static void readAll(Path dir, boolean parallel, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, parallel, LocalComputationManager.getDefault(), ImportConfig.CACHE.get(), consumer, listener);
    }

    public static void readAll(Path dir, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Network.readAll(dir, false, LocalComputationManager.getDefault(), ImportConfig.CACHE.get(), consumer);
    }

    default public void update(ReadOnlyDataSource dataSource) {
        this.update(dataSource, null);
    }

    default public void update(ReadOnlyDataSource dataSource, Properties properties) {
        this.update(dataSource, properties, ReportNode.NO_OP);
    }

    default public void update(ReadOnlyDataSource dataSource, Properties parameters, ReportNode reportNode) {
        this.update(dataSource, LocalComputationManager.getDefault(), ImportConfig.load(), parameters, new ImportersServiceLoader(), reportNode);
    }

    default public void update(ReadOnlyDataSource dataSource, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader, ReportNode reportNode) {
        Importer importer = Importer.find(dataSource, loader, computationManager, config);
        if (importer == null) {
            throw new PowsyblException("Unsupported file format or invalid file.");
        }
        importer.update(this, dataSource, parameters, reportNode);
    }

    public static Network create(String id, String sourceFormat) {
        return NetworkFactory.findDefault().createNetwork(id, sourceFormat);
    }

    public static Network merge(Network ... networks) {
        return NetworkFactory.findDefault().merge(networks);
    }

    public static Network merge(String id, Network ... networks) {
        return NetworkFactory.findDefault().merge(id, networks);
    }

    public static PrettyNetworkFactory with(String name) {
        return (id, sourceFormat) -> NetworkFactory.find(name).createNetwork(id, sourceFormat);
    }

    public ZonedDateTime getCaseDate();

    public Network setCaseDate(ZonedDateTime var1);

    public int getForecastDistance();

    public Network setForecastDistance(int var1);

    public String getSourceFormat();

    public VariantManager getVariantManager();

    public void allowReportNodeContextMultiThreadAccess(boolean var1);

    public ReportNodeContext getReportNodeContext();

    public Set<Country> getCountries();

    public int getCountryCount();

    public Iterable<String> getAreaTypes();

    public Stream<String> getAreaTypeStream();

    public int getAreaTypeCount();

    public AreaAdder newArea();

    public Iterable<Area> getAreas();

    public Stream<Area> getAreaStream();

    public Area getArea(String var1);

    public int getAreaCount();

    public SubstationAdder newSubstation();

    public Iterable<Substation> getSubstations();

    public Stream<Substation> getSubstationStream();

    public int getSubstationCount();

    public Iterable<Substation> getSubstations(Country var1, String var2, String ... var3);

    public Iterable<Substation> getSubstations(String var1, String var2, String ... var3);

    public Substation getSubstation(String var1);

    default public VoltageLevelAdder newVoltageLevel() {
        return ((SubstationAdder)((SubstationAdder)((SubstationAdder)this.newSubstation().setId("FICTITIOUS_SUBSTATION")).setEnsureIdUnicity(true)).setFictitious(true)).add().newVoltageLevel();
    }

    public Iterable<VoltageLevel> getVoltageLevels();

    public Stream<VoltageLevel> getVoltageLevelStream();

    public int getVoltageLevelCount();

    public VoltageLevel getVoltageLevel(String var1);

    public LineAdder newLine();

    public LineAdder newLine(Line var1);

    public Iterable<Line> getLines();

    public Iterable<TieLine> getTieLines();

    public Branch getBranch(String var1);

    public Iterable<Branch> getBranches();

    public Stream<Branch> getBranchStream();

    public int getBranchCount();

    public Stream<Line> getLineStream();

    public Stream<TieLine> getTieLineStream();

    public int getLineCount();

    public int getTieLineCount();

    public Line getLine(String var1);

    public TieLine getTieLine(String var1);

    public TieLineAdder newTieLine();

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers();

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream();

    public int getTwoWindingsTransformerCount();

    public TwoWindingsTransformer getTwoWindingsTransformer(String var1);

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers();

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream();

    public int getThreeWindingsTransformerCount();

    public ThreeWindingsTransformer getThreeWindingsTransformer(String var1);

    public Iterable<OverloadManagementSystem> getOverloadManagementSystems();

    public Stream<OverloadManagementSystem> getOverloadManagementSystemStream();

    public int getOverloadManagementSystemCount();

    public OverloadManagementSystem getOverloadManagementSystem(String var1);

    public Iterable<Generator> getGenerators();

    public Stream<Generator> getGeneratorStream();

    public int getGeneratorCount();

    public Generator getGenerator(String var1);

    public Iterable<Battery> getBatteries();

    public Stream<Battery> getBatteryStream();

    public int getBatteryCount();

    public Battery getBattery(String var1);

    public Iterable<Load> getLoads();

    public Stream<Load> getLoadStream();

    public int getLoadCount();

    public Load getLoad(String var1);

    public Iterable<ShuntCompensator> getShuntCompensators();

    public Stream<ShuntCompensator> getShuntCompensatorStream();

    public int getShuntCompensatorCount();

    public ShuntCompensator getShuntCompensator(String var1);

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter var1);

    default public Iterable<DanglingLine> getDanglingLines() {
        return this.getDanglingLines(DanglingLineFilter.ALL);
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter var1);

    default public Stream<DanglingLine> getDanglingLineStream() {
        return this.getDanglingLineStream(DanglingLineFilter.ALL);
    }

    public int getDanglingLineCount();

    public DanglingLine getDanglingLine(String var1);

    public Iterable<StaticVarCompensator> getStaticVarCompensators();

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream();

    public int getStaticVarCompensatorCount();

    public StaticVarCompensator getStaticVarCompensator(String var1);

    public Switch getSwitch(String var1);

    public Iterable<Switch> getSwitches();

    public Stream<Switch> getSwitchStream();

    public int getSwitchCount();

    public BusbarSection getBusbarSection(String var1);

    public Iterable<BusbarSection> getBusbarSections();

    public Stream<BusbarSection> getBusbarSectionStream();

    public int getBusbarSectionCount();

    public Iterable<HvdcConverterStation<?>> getHvdcConverterStations();

    public Stream<HvdcConverterStation<?>> getHvdcConverterStationStream();

    public int getHvdcConverterStationCount();

    public HvdcConverterStation<?> getHvdcConverterStation(String var1);

    public Iterable<LccConverterStation> getLccConverterStations();

    public Stream<LccConverterStation> getLccConverterStationStream();

    public int getLccConverterStationCount();

    public LccConverterStation getLccConverterStation(String var1);

    public Iterable<VscConverterStation> getVscConverterStations();

    public Stream<VscConverterStation> getVscConverterStationStream();

    public int getVscConverterStationCount();

    public VscConverterStation getVscConverterStation(String var1);

    public Iterable<HvdcLine> getHvdcLines();

    public Stream<HvdcLine> getHvdcLineStream();

    public int getHvdcLineCount();

    public HvdcLine getHvdcLine(String var1);

    default public HvdcLine getHvdcLine(HvdcConverterStation converterStation) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public HvdcLineAdder newHvdcLine();

    public Iterable<Ground> getGrounds();

    public Stream<Ground> getGroundStream();

    public int getGroundCount();

    public Ground getGround(String var1);

    public DcNodeAdder newDcNode();

    public Iterable<DcNode> getDcNodes();

    public Stream<DcNode> getDcNodeStream();

    public int getDcNodeCount();

    public DcNode getDcNode(String var1);

    public DcLineAdder newDcLine();

    public Iterable<DcLine> getDcLines();

    public Stream<DcLine> getDcLineStream();

    public int getDcLineCount();

    public DcLine getDcLine(String var1);

    public DcSwitchAdder newDcSwitch();

    public Iterable<DcSwitch> getDcSwitches();

    public Stream<DcSwitch> getDcSwitchStream();

    public int getDcSwitchCount();

    public DcSwitch getDcSwitch(String var1);

    public DcGroundAdder newDcGround();

    public Iterable<DcGround> getDcGrounds();

    public Stream<DcGround> getDcGroundStream();

    public int getDcGroundCount();

    public DcGround getDcGround(String var1);

    public Iterable<LineCommutatedConverter> getLineCommutatedConverters();

    public Stream<LineCommutatedConverter> getLineCommutatedConverterStream();

    public int getLineCommutatedConverterCount();

    public LineCommutatedConverter getLineCommutatedConverter(String var1);

    public Iterable<VoltageSourceConverter> getVoltageSourceConverters();

    public Stream<VoltageSourceConverter> getVoltageSourceConverterStream();

    public int getVoltageSourceConverterCount();

    public VoltageSourceConverter getVoltageSourceConverter(String var1);

    public Identifiable<?> getIdentifiable(String var1);

    public Collection<Identifiable<?>> getIdentifiables();

    default public <C extends Connectable> Iterable<C> getConnectables(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    default public <C extends Connectable> Stream<C> getConnectableStream(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    default public <C extends Connectable> int getConnectableCount(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    default public Iterable<Connectable> getConnectables() {
        throw new UnsupportedOperationException();
    }

    default public Stream<Connectable> getConnectableStream() {
        throw new UnsupportedOperationException();
    }

    default public Connectable<?> getConnectable(String id) {
        Identifiable<?> identifiable = this.getIdentifiable(id);
        if (identifiable instanceof Connectable) {
            return (Connectable)identifiable;
        }
        return null;
    }

    default public int getConnectableCount() {
        throw new UnsupportedOperationException();
    }

    default public <C extends DcConnectable> Iterable<C> getDcConnectables(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    default public <C extends DcConnectable> Stream<C> getDcConnectableStream(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    default public <C extends DcConnectable> int getDcConnectableCount(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    default public Iterable<DcConnectable> getDcConnectables() {
        throw new UnsupportedOperationException();
    }

    default public Stream<DcConnectable> getDcConnectableStream() {
        throw new UnsupportedOperationException();
    }

    default public DcConnectable<?> getDcConnectable(String id) {
        Identifiable<?> identifiable = this.getIdentifiable(id);
        if (identifiable instanceof DcConnectable) {
            return (DcConnectable)identifiable;
        }
        return null;
    }

    default public int getDcConnectableCount() {
        throw new UnsupportedOperationException();
    }

    public BusBreakerView getBusBreakerView();

    public BusView getBusView();

    public VoltageAngleLimitAdder newVoltageAngleLimit();

    public Iterable<VoltageAngleLimit> getVoltageAngleLimits();

    public Stream<VoltageAngleLimit> getVoltageAngleLimitsStream();

    public VoltageAngleLimit getVoltageAngleLimit(String var1);

    public Network createSubnetwork(String var1, String var2, String var3);

    public Network detach();

    public boolean isDetachable();

    public Set<Identifiable<?>> getBoundaryElements();

    public boolean isBoundaryElement(Identifiable<?> var1);

    public void flatten();

    public void addListener(NetworkListener var1);

    public void removeListener(NetworkListener var1);

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.NETWORK;
    }

    default public ValidationLevel runValidationChecks() {
        return this.runValidationChecks(true);
    }

    default public ValidationLevel runValidationChecks(boolean throwsException) {
        return this.runValidationChecks(throwsException, ReportNode.NO_OP);
    }

    default public ValidationLevel runValidationChecks(boolean throwsException, ReportNode reportNode) {
        return ValidationLevel.STEADY_STATE_HYPOTHESIS;
    }

    default public ValidationLevel getValidationLevel() {
        return ValidationLevel.STEADY_STATE_HYPOTHESIS;
    }

    default public Network setMinimumAcceptableValidationLevel(ValidationLevel validationLevel) {
        if (validationLevel != ValidationLevel.STEADY_STATE_HYPOTHESIS) {
            throw new UnsupportedOperationException("Validation level below STEADY_STATE_HYPOTHESIS not supported");
        }
        return this;
    }

    default public Stream<Identifiable<?>> getIdentifiableStream(IdentifiableType identifiableType) {
        return switch (identifiableType) {
            case IdentifiableType.SWITCH -> this.getSwitchStream().map(Function.identity());
            case IdentifiableType.TWO_WINDINGS_TRANSFORMER -> this.getTwoWindingsTransformerStream().map(Function.identity());
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> this.getThreeWindingsTransformerStream().map(Function.identity());
            case IdentifiableType.DANGLING_LINE -> this.getDanglingLineStream(DanglingLineFilter.ALL).map(Function.identity());
            case IdentifiableType.LINE -> this.getLineStream().map(Function.identity());
            case IdentifiableType.TIE_LINE -> this.getTieLineStream().map(Function.identity());
            case IdentifiableType.LOAD -> this.getLoadStream().map(Function.identity());
            case IdentifiableType.BATTERY -> this.getBatteryStream().map(Function.identity());
            case IdentifiableType.GENERATOR -> this.getGeneratorStream().map(Function.identity());
            case IdentifiableType.HVDC_LINE -> this.getHvdcLineStream().map(Function.identity());
            case IdentifiableType.SUBSTATION -> this.getSubstationStream().map(Function.identity());
            case IdentifiableType.VOLTAGE_LEVEL -> this.getVoltageLevelStream().map(Function.identity());
            case IdentifiableType.BUSBAR_SECTION -> this.getBusbarSectionStream().map(Function.identity());
            case IdentifiableType.SHUNT_COMPENSATOR -> this.getShuntCompensatorStream().map(Function.identity());
            case IdentifiableType.HVDC_CONVERTER_STATION -> this.getHvdcConverterStationStream().map(Function.identity());
            case IdentifiableType.STATIC_VAR_COMPENSATOR -> this.getStaticVarCompensatorStream().map(Function.identity());
            case IdentifiableType.GROUND -> this.getGroundStream().map(Function.identity());
            case IdentifiableType.AREA -> this.getAreaStream().map(Function.identity());
            case IdentifiableType.OVERLOAD_MANAGEMENT_SYSTEM -> this.getOverloadManagementSystemStream().map(Function.identity());
            case IdentifiableType.DC_NODE -> this.getDcNodeStream().map(Function.identity());
            case IdentifiableType.DC_LINE -> this.getDcLineStream().map(Function.identity());
            case IdentifiableType.DC_GROUND -> this.getDcGroundStream().map(Function.identity());
            case IdentifiableType.DC_SWITCH -> this.getDcSwitchStream().map(Function.identity());
            case IdentifiableType.LINE_COMMUTATED_CONVERTER -> this.getLineCommutatedConverterStream().map(Function.identity());
            case IdentifiableType.VOLTAGE_SOURCE_CONVERTER -> this.getVoltageSourceConverterStream().map(Function.identity());
            default -> throw new PowsyblException("can get a stream of " + identifiableType + " from a network.");
        };
    }

    default public void write(ExportersLoader loader, String format, Properties parameters, DataSource dataSource, ReportNode reportNode) {
        Exporter exporter = Exporter.find(loader, format);
        if (exporter == null) {
            throw new PowsyblException("Export format " + format + " not supported");
        }
        exporter.export(this, parameters, dataSource, reportNode);
    }

    default public void write(ExportersLoader loader, String format, Properties parameters, DataSource dataSource) {
        this.write(loader, format, parameters, dataSource, ReportNode.NO_OP);
    }

    default public void write(String format, Properties parameters, DataSource dataSource) {
        this.write((ExportersLoader)new ExportersServiceLoader(), format, parameters, dataSource);
    }

    default public void write(ExportersLoader loader, String format, Properties parameters, Path file, ReportNode reportNode) {
        DataSource dataSource = Exporters.createDataSource(file);
        this.write(loader, format, parameters, dataSource, reportNode);
    }

    default public void write(ExportersLoader loader, String format, Properties parameters, Path file) {
        this.write(loader, format, parameters, file, ReportNode.NO_OP);
    }

    default public void write(String format, Properties parameters, Path file) {
        this.write((ExportersLoader)new ExportersServiceLoader(), format, parameters, file);
    }

    default public void write(ExportersLoader loader, String format, Properties parameters, String directory, String baseName, ReportNode reportNode) {
        this.write(loader, format, parameters, (DataSource)new DirectoryDataSource(Paths.get(directory, new String[0]), baseName), reportNode);
    }

    default public void write(ExportersLoader loader, String format, Properties parameters, String directory, String basename) {
        this.write(loader, format, parameters, directory, basename, ReportNode.NO_OP);
    }

    default public void write(String format, Properties parameters, String directory, String baseName) {
        this.write((ExportersLoader)new ExportersServiceLoader(), format, parameters, directory, baseName);
    }

    public static interface PrettyNetworkFactory {
        public Network create(String var1, String var2);
    }

    public static interface BusView {
        public Iterable<Bus> getBuses();

        public Stream<Bus> getBusStream();

        default public Bus getBus(String id) {
            throw new PowsyblException("Method should be overridden in the current implementation");
        }

        public Collection<Component> getConnectedComponents();

        public Collection<Component> getSynchronousComponents();
    }

    public static interface BusBreakerView {
        public Iterable<Bus> getBuses();

        public Stream<Bus> getBusStream();

        public int getBusCount();

        public Iterable<Switch> getSwitches();

        public Stream<Switch> getSwitchStream();

        public int getSwitchCount();

        default public Bus getBus(String id) {
            throw new PowsyblException("Method should be overridden in the current implementation");
        }
    }
}

