/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.events.CreationNetworkEvent;
import com.powsybl.iidm.network.events.ExtensionCreationNetworkEvent;
import com.powsybl.iidm.network.events.ExtensionRemovalNetworkEvent;
import com.powsybl.iidm.network.events.ExtensionUpdateNetworkEvent;
import com.powsybl.iidm.network.events.NetworkEvent;
import com.powsybl.iidm.network.events.PropertiesUpdateNetworkEvent;
import com.powsybl.iidm.network.events.RemovalNetworkEvent;
import com.powsybl.iidm.network.events.UpdateNetworkEvent;
import com.powsybl.iidm.network.events.VariantNetworkEvent;
import java.util.ArrayList;
import java.util.List;

public class NetworkEventRecorder
implements NetworkListener {
    private final List<NetworkEvent> events = new ArrayList<NetworkEvent>();

    public List<NetworkEvent> getEvents() {
        return this.events;
    }

    public void reset() {
        this.events.clear();
    }

    @Override
    public void onCreation(Identifiable<?> identifiable) {
        this.events.add(new CreationNetworkEvent(identifiable.getId()));
    }

    @Override
    public void beforeRemoval(Identifiable<?> identifiable) {
        this.events.add(new RemovalNetworkEvent(identifiable.getId(), false));
    }

    @Override
    public void afterRemoval(String id) {
        this.events.add(new RemovalNetworkEvent(id, true));
    }

    @Override
    public void onUpdate(Identifiable<?> identifiable, String attribute, String variantId, Object oldValue, Object newValue) {
        this.events.add(new UpdateNetworkEvent(identifiable.getId(), attribute, variantId, oldValue, newValue));
    }

    @Override
    public void onExtensionCreation(Extension<?> extension) {
        this.events.add(new ExtensionCreationNetworkEvent(((Identifiable)extension.getExtendable()).getId(), extension.getName()));
    }

    @Override
    public void onExtensionAfterRemoval(Identifiable<?> identifiable, String extensionName) {
        this.events.add(new ExtensionRemovalNetworkEvent(identifiable.getId(), extensionName, true));
    }

    @Override
    public void onExtensionBeforeRemoval(Extension<?> extension) {
        this.events.add(new ExtensionRemovalNetworkEvent(((Identifiable)extension.getExtendable()).getId(), extension.getName(), false));
    }

    @Override
    public void onExtensionUpdate(Extension<?> extension, String attribute, String variantId, Object oldValue, Object newValue) {
        this.events.add(new ExtensionUpdateNetworkEvent(((Identifiable)extension.getExtendable()).getId(), extension.getName(), attribute, variantId, oldValue, newValue));
    }

    @Override
    public void onPropertyAdded(Identifiable<?> identifiable, String key, Object newValue) {
        this.events.add(new PropertiesUpdateNetworkEvent(identifiable.getId(), key, PropertiesUpdateNetworkEvent.PropertyUpdateType.ADDED, null, newValue));
    }

    @Override
    public void onPropertyReplaced(Identifiable<?> identifiable, String key, Object oldValue, Object newValue) {
        this.events.add(new PropertiesUpdateNetworkEvent(identifiable.getId(), key, PropertiesUpdateNetworkEvent.PropertyUpdateType.REPLACED, oldValue, newValue));
    }

    @Override
    public void onPropertyRemoved(Identifiable<?> identifiable, String key, Object oldValue) {
        this.events.add(new PropertiesUpdateNetworkEvent(identifiable.getId(), key, PropertiesUpdateNetworkEvent.PropertyUpdateType.REMOVED, oldValue, null));
    }

    @Override
    public void onVariantCreated(String sourceVariantId, String targetVariantId) {
        this.events.add(new VariantNetworkEvent(sourceVariantId, targetVariantId, VariantNetworkEvent.VariantEventType.CREATED));
    }

    @Override
    public void onVariantOverwritten(String sourceVariantId, String targetVariantId) {
        this.events.add(new VariantNetworkEvent(sourceVariantId, targetVariantId, VariantNetworkEvent.VariantEventType.OVERWRITTEN));
    }

    @Override
    public void onVariantRemoved(String variantId) {
        this.events.add(new VariantNetworkEvent(variantId, null, VariantNetworkEvent.VariantEventType.REMOVED));
    }
}

