/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.ShuntCompensatorModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ValidationUtil;
import java.util.OptionalInt;

public interface ShuntCompensator
extends Injection<ShuntCompensator> {
    public int getSectionCount();

    default public OptionalInt findSectionCount() {
        return OptionalInt.of(this.getSectionCount());
    }

    public Integer getSolvedSectionCount();

    default public OptionalInt findSolvedSectionCount() {
        return this.getSolvedSectionCount() != null ? OptionalInt.of(this.getSolvedSectionCount()) : OptionalInt.empty();
    }

    public int getMaximumSectionCount();

    public ShuntCompensator setSectionCount(int var1);

    default public ShuntCompensator unsetSectionCount() {
        throw ValidationUtil.createUnsetMethodException();
    }

    public ShuntCompensator setSolvedSectionCount(int var1);

    default public ShuntCompensator unsetSolvedSectionCount() {
        throw ValidationUtil.createUnsetMethodException();
    }

    public double getB();

    public double getG();

    public double getB(int var1);

    public double getG(int var1);

    public ShuntCompensatorModelType getModelType();

    public ShuntCompensatorModel getModel();

    public <M extends ShuntCompensatorModel> M getModel(Class<M> var1);

    default public Terminal getRegulatingTerminal() {
        throw new UnsupportedOperationException();
    }

    default public ShuntCompensator setRegulatingTerminal(Terminal regulatingTerminal) {
        throw new UnsupportedOperationException();
    }

    public boolean isVoltageRegulatorOn();

    default public ShuntCompensator setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        throw new UnsupportedOperationException();
    }

    default public double getTargetV() {
        throw new UnsupportedOperationException();
    }

    default public ShuntCompensator setTargetV(double targetV) {
        throw new UnsupportedOperationException();
    }

    default public double getTargetDeadband() {
        throw new UnsupportedOperationException();
    }

    default public ShuntCompensator setTargetDeadband(double targetDeadband) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.SHUNT_COMPENSATOR;
    }

    default public void applySolvedValues() {
        this.setSectionCountToSolvedSectionCount();
    }

    default public void setSectionCountToSolvedSectionCount() {
        OptionalInt solvedSectionCount = this.findSolvedSectionCount();
        if (solvedSectionCount.isPresent()) {
            this.setSectionCount(solvedSectionCount.getAsInt());
        }
    }
}

