/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.identifiers;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class IdWithWildcardsNetworkElementIdentifier
implements NetworkElementIdentifier {
    public static final int ALLOWED_WILDCARDS_NUMBER = 5;
    public static final String DEFAULT_WILDCARD_CHARACTER = "?";
    private final String originalIdentifier;
    private String identifierPattern;
    private final String wildcardCharacter;
    private final String contingencyId;

    public IdWithWildcardsNetworkElementIdentifier(String identifier) {
        this(identifier, DEFAULT_WILDCARD_CHARACTER, null);
    }

    public IdWithWildcardsNetworkElementIdentifier(String identifier, String contingencyId) {
        this(identifier, DEFAULT_WILDCARD_CHARACTER, contingencyId);
    }

    public IdWithWildcardsNetworkElementIdentifier(String identifier, String wildcardCharacter, String contingencyId) {
        this.originalIdentifier = Objects.requireNonNull(identifier);
        this.contingencyId = contingencyId;
        if (wildcardCharacter.codePointCount(0, wildcardCharacter.length()) != 1) {
            throw new IllegalArgumentException("Wildcard character must be a single character");
        }
        this.wildcardCharacter = wildcardCharacter;
        this.initialize();
    }

    private void initialize() {
        int separatorNumber = StringUtils.countMatches((CharSequence)this.originalIdentifier, (CharSequence)this.wildcardCharacter);
        if (separatorNumber > 5) {
            throw new PowsyblException("There can be a maximum of 5 wildcards ('" + this.wildcardCharacter + "')");
        }
        if (separatorNumber == 0) {
            throw new PowsyblException("There is no wildcard in your identifier, please use IdBasedNetworkElementIdentifier instead");
        }
        String[] chunks = this.originalIdentifier.split(Pattern.quote(this.wildcardCharacter));
        StringJoiner sj = new StringJoiner(".");
        Stream.of(chunks).forEach(c -> sj.add(Pattern.quote(c)));
        if (this.originalIdentifier.endsWith(this.wildcardCharacter)) {
            sj.add("");
        }
        this.identifierPattern = sj.toString();
    }

    @Override
    public Set<Identifiable> filterIdentifiable(Network network) {
        return network.getIdentifiables().stream().filter(identifiable -> identifiable.getId().matches(this.identifierPattern)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<String> getNotFoundElements(Network network) {
        Identifiable<?> identifiable = network.getIdentifiable(this.identifierPattern);
        return identifiable == null ? Collections.singleton(this.identifierPattern) : Collections.emptySet();
    }

    @Override
    public NetworkElementIdentifier.IdentifierType getType() {
        return NetworkElementIdentifier.IdentifierType.ID_WITH_WILDCARDS;
    }

    @Override
    public Optional<String> getContingencyId() {
        return Optional.ofNullable(this.contingencyId);
    }

    public String getIdentifier() {
        return this.originalIdentifier;
    }

    public String getWildcardCharacter() {
        return this.wildcardCharacter;
    }
}

