/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraverseResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public final class NodeBreakerTopology {
    private NodeBreakerTopology() {
    }

    public static void removeIsolatedSwitches(VoltageLevel.NodeBreakerView topo) {
        Objects.requireNonNull(topo, "Node breaker topology view is null.");
        HashSet encounteredSwitches = new HashSet();
        int[] nodesWithTerminal = Arrays.stream(topo.getNodes()).filter(n -> topo.getTerminal(n) != null).toArray();
        topo.traverse(nodesWithTerminal, (n1, sw, n2) -> {
            encounteredSwitches.add(sw);
            return TraverseResult.CONTINUE;
        });
        topo.getSwitchStream().filter(sw -> !encounteredSwitches.contains(sw)).forEach(s -> topo.removeSwitch(s.getId()));
    }

    public static int newStandardConnection(BusbarSection bb) {
        Objects.requireNonNull(bb, "Busbar section is null.");
        int n = bb.getTerminal().getNodeBreakerView().getNode();
        VoltageLevel.NodeBreakerView topo = bb.getTerminal().getVoltageLevel().getNodeBreakerView();
        int oldCount = topo.getMaximumNodeIndex() + 1;
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topo.newDisconnector().setId(String.format("disconnector %s-%d", bb.getId(), oldCount))).setNode1(n).setNode2(oldCount).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topo.newBreaker().setId(String.format("breaker %s-%d", bb.getId(), oldCount + 1))).setNode1(oldCount).setNode2(oldCount + 1).add();
        return oldCount + 1;
    }
}

