/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.LoadingLimitsUtil;
import java.util.Collection;
import java.util.Optional;

public interface Branch<I extends Branch<I>>
extends Identifiable<I> {
    public Terminal getTerminal1();

    public Terminal getTerminal2();

    public Terminal getTerminal(TwoSides var1);

    public Terminal getTerminal(String var1);

    public TwoSides getSide(Terminal var1);

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups1();

    public Optional<String> getSelectedOperationalLimitsGroupId1();

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup1(String var1);

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup1();

    public OperationalLimitsGroup newOperationalLimitsGroup1(String var1);

    public void setSelectedOperationalLimitsGroup1(String var1);

    public void removeOperationalLimitsGroup1(String var1);

    public void cancelSelectedOperationalLimitsGroup1();

    default public Optional<CurrentLimits> getCurrentLimits1() {
        return this.getSelectedOperationalLimitsGroup1().flatMap(OperationalLimitsGroup::getCurrentLimits);
    }

    default public CurrentLimits getNullableCurrentLimits1() {
        return this.getCurrentLimits1().orElse(null);
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits1() {
        return this.getSelectedOperationalLimitsGroup1().flatMap(OperationalLimitsGroup::getActivePowerLimits);
    }

    default public ActivePowerLimits getNullableActivePowerLimits1() {
        return this.getActivePowerLimits1().orElse(null);
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits1() {
        return this.getSelectedOperationalLimitsGroup1().flatMap(OperationalLimitsGroup::getApparentPowerLimits);
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits1() {
        return this.getApparentPowerLimits1().orElse(null);
    }

    @Deprecated(since="6.8.0")
    public CurrentLimitsAdder newCurrentLimits1();

    @Deprecated(since="6.8.0")
    default public CurrentLimitsAdder newCurrentLimits1(CurrentLimits currentLimits) {
        CurrentLimitsAdder currentLimitsAdder = this.newCurrentLimits1();
        return LoadingLimitsUtil.initializeFromLoadingLimits(currentLimitsAdder, currentLimits);
    }

    public OperationalLimitsGroup getOrCreateSelectedOperationalLimitsGroup1();

    public OperationalLimitsGroup getOrCreateSelectedOperationalLimitsGroup2();

    default public OperationalLimitsGroup getOrCreateSelectedOperationalLimitsGroup1(String limitsGroupId) {
        OperationalLimitsGroup operationalLimitsGroup = this.getOperationalLimitsGroup1(limitsGroupId).orElseGet(() -> this.newOperationalLimitsGroup1(limitsGroupId));
        this.setSelectedOperationalLimitsGroup1(limitsGroupId);
        return operationalLimitsGroup;
    }

    default public OperationalLimitsGroup getOrCreateSelectedOperationalLimitsGroup2(String limitsGroupId) {
        OperationalLimitsGroup operationalLimitsGroup = this.getOperationalLimitsGroup2(limitsGroupId).orElseGet(() -> this.newOperationalLimitsGroup2(limitsGroupId));
        this.setSelectedOperationalLimitsGroup2(limitsGroupId);
        return operationalLimitsGroup;
    }

    @Deprecated(since="6.8.0")
    public ActivePowerLimitsAdder newActivePowerLimits1();

    @Deprecated(since="6.8.0")
    default public ActivePowerLimitsAdder newActivePowerLimits1(ActivePowerLimits activePowerLimits) {
        ActivePowerLimitsAdder activePowerLimitsAdder = this.newActivePowerLimits1();
        return LoadingLimitsUtil.initializeFromLoadingLimits(activePowerLimitsAdder, activePowerLimits);
    }

    @Deprecated(since="6.8.0")
    public ApparentPowerLimitsAdder newApparentPowerLimits1();

    @Deprecated(since="6.8.0")
    default public ApparentPowerLimitsAdder newApparentPowerLimits1(ApparentPowerLimits apparentPowerLimits) {
        ApparentPowerLimitsAdder apparentPowerLimitsAdder = this.newApparentPowerLimits1();
        return LoadingLimitsUtil.initializeFromLoadingLimits(apparentPowerLimitsAdder, apparentPowerLimits);
    }

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups2();

    public Optional<String> getSelectedOperationalLimitsGroupId2();

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup2(String var1);

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup2();

    public OperationalLimitsGroup newOperationalLimitsGroup2(String var1);

    public void setSelectedOperationalLimitsGroup2(String var1);

    public void removeOperationalLimitsGroup2(String var1);

    public void cancelSelectedOperationalLimitsGroup2();

    default public Optional<CurrentLimits> getCurrentLimits2() {
        return this.getSelectedOperationalLimitsGroup2().flatMap(OperationalLimitsGroup::getCurrentLimits);
    }

    default public CurrentLimits getNullableCurrentLimits2() {
        return this.getCurrentLimits2().orElse(null);
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits2() {
        return this.getSelectedOperationalLimitsGroup2().flatMap(OperationalLimitsGroup::getActivePowerLimits);
    }

    default public ActivePowerLimits getNullableActivePowerLimits2() {
        return this.getActivePowerLimits2().orElse(null);
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits2() {
        return this.getSelectedOperationalLimitsGroup2().flatMap(OperationalLimitsGroup::getApparentPowerLimits);
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits2() {
        return this.getApparentPowerLimits2().orElse(null);
    }

    @Deprecated(since="6.8.0")
    public CurrentLimitsAdder newCurrentLimits2();

    @Deprecated(since="6.8.0")
    default public CurrentLimitsAdder newCurrentLimits2(CurrentLimits currentLimits) {
        CurrentLimitsAdder currentLimitsAdder = this.newCurrentLimits2();
        return LoadingLimitsUtil.initializeFromLoadingLimits(currentLimitsAdder, currentLimits);
    }

    @Deprecated(since="6.8.0")
    public ActivePowerLimitsAdder newActivePowerLimits2();

    @Deprecated(since="6.8.0")
    default public ActivePowerLimitsAdder newActivePowerLimits2(ActivePowerLimits activePowerLimits) {
        ActivePowerLimitsAdder activePowerLimitsAdder = this.newActivePowerLimits2();
        return LoadingLimitsUtil.initializeFromLoadingLimits(activePowerLimitsAdder, activePowerLimits);
    }

    @Deprecated(since="6.8.0")
    public ApparentPowerLimitsAdder newApparentPowerLimits2();

    @Deprecated(since="6.8.0")
    default public ApparentPowerLimitsAdder newApparentPowerLimits2(ApparentPowerLimits apparentPowerLimits) {
        ApparentPowerLimitsAdder apparentPowerLimitsAdder = this.newApparentPowerLimits2();
        return LoadingLimitsUtil.initializeFromLoadingLimits(apparentPowerLimitsAdder, apparentPowerLimits);
    }

    default public Optional<CurrentLimits> getCurrentLimits(TwoSides side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TwoSides.ONE -> this.getCurrentLimits1();
            case TwoSides.TWO -> this.getCurrentLimits2();
        };
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits(TwoSides side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TwoSides.ONE -> this.getActivePowerLimits1();
            case TwoSides.TWO -> this.getActivePowerLimits2();
        };
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits(TwoSides side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TwoSides.ONE -> this.getApparentPowerLimits1();
            case TwoSides.TWO -> this.getApparentPowerLimits2();
        };
    }

    default public Optional<? extends LoadingLimits> getLimits(LimitType type, TwoSides side) {
        return switch (type) {
            case LimitType.CURRENT -> this.getCurrentLimits(side);
            case LimitType.ACTIVE_POWER -> this.getActivePowerLimits(side);
            case LimitType.APPARENT_POWER -> this.getApparentPowerLimits(side);
            default -> throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
        };
    }

    default public CurrentLimits getNullableCurrentLimits(TwoSides side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TwoSides.ONE -> this.getNullableCurrentLimits1();
            case TwoSides.TWO -> this.getNullableCurrentLimits2();
        };
    }

    default public ActivePowerLimits getNullableActivePowerLimits(TwoSides side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TwoSides.ONE -> this.getNullableActivePowerLimits1();
            case TwoSides.TWO -> this.getNullableActivePowerLimits2();
        };
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits(TwoSides side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TwoSides.ONE -> this.getNullableApparentPowerLimits1();
            case TwoSides.TWO -> this.getNullableApparentPowerLimits2();
        };
    }

    default public LoadingLimits getNullableLimits(LimitType type, TwoSides side) {
        return switch (type) {
            case LimitType.CURRENT -> this.getNullableCurrentLimits(side);
            case LimitType.ACTIVE_POWER -> this.getNullableActivePowerLimits(side);
            case LimitType.APPARENT_POWER -> this.getNullableApparentPowerLimits(side);
            default -> throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
        };
    }

    public boolean isOverloaded();

    public boolean isOverloaded(double var1);

    public int getOverloadDuration();

    public boolean checkPermanentLimit(TwoSides var1, double var2, LimitType var4);

    public boolean checkPermanentLimit(TwoSides var1, LimitType var2);

    public boolean checkPermanentLimit1(double var1, LimitType var3);

    public boolean checkPermanentLimit1(LimitType var1);

    public boolean checkPermanentLimit2(double var1, LimitType var3);

    public boolean checkPermanentLimit2(LimitType var1);

    public Overload checkTemporaryLimits(TwoSides var1, double var2, LimitType var4);

    public Overload checkTemporaryLimits(TwoSides var1, LimitType var2);

    public Overload checkTemporaryLimits1(double var1, LimitType var3);

    public Overload checkTemporaryLimits1(LimitType var1);

    public Overload checkTemporaryLimits2(double var1, LimitType var3);

    public Overload checkTemporaryLimits2(LimitType var1);
}

