/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.Terminal;

public interface Generator
extends Injection<Generator>,
ReactiveLimitsHolder {
    public EnergySource getEnergySource();

    public Generator setEnergySource(EnergySource var1);

    public double getMaxP();

    public Generator setMaxP(double var1);

    public double getMinP();

    public Generator setMinP(double var1);

    public boolean isVoltageRegulatorOn();

    public Generator setVoltageRegulatorOn(boolean var1);

    public Terminal getRegulatingTerminal();

    public Generator setRegulatingTerminal(Terminal var1);

    public double getTargetV();

    public Generator setTargetV(double var1);

    public double getTargetP();

    public Generator setTargetP(double var1);

    public double getTargetQ();

    public Generator setTargetQ(double var1);

    public double getRatedS();

    public Generator setRatedS(double var1);

    public boolean isCondenser();

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.GENERATOR;
    }

    default public void applySolvedValues() {
        this.setTargetPToP();
        this.setTargetQToQ();
        this.setTargetVToV();
    }

    default public void setTargetPToP() {
        double p = this.getTerminal().getP();
        if (!Double.isNaN(p)) {
            this.setTargetP(-p);
        }
    }

    default public void setTargetQToQ() {
        double q = this.getTerminal().getQ();
        if (!Double.isNaN(q)) {
            this.setTargetQ(-q);
        }
    }

    default public void setTargetVToV() {
        Bus bus = this.getTerminal().getBusView().getBus();
        if (bus != null && !Double.isNaN(bus.getV())) {
            this.setTargetV(bus.getV());
        }
    }
}

