/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.AbstractReportNodeContext;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class MultiThreadReportNodeContext
extends AbstractReportNodeContext {
    private final ThreadLocal<Deque<ReportNode>> reportNodes = ThreadLocal.withInitial(() -> {
        LinkedList<ReportNode> deque = new LinkedList<ReportNode>();
        deque.push(ReportNode.NO_OP);
        return deque;
    });

    public MultiThreadReportNodeContext() {
    }

    public MultiThreadReportNodeContext(AbstractReportNodeContext reportNodeContext) {
        this();
        this.copyReportNodes(reportNodeContext);
    }

    @Override
    public ReportNode getReportNode() {
        return this.reportNodes.get().peek();
    }

    @Override
    public void pushReportNode(ReportNode reportNode) {
        this.reportNodes.get().push(reportNode);
    }

    @Override
    public ReportNode popReportNode() {
        ReportNode popped = this.reportNodes.get().pop();
        if (this.reportNodes.get().isEmpty()) {
            this.reportNodes.get().push(ReportNode.NO_OP);
        }
        return popped;
    }

    public void close() {
        this.reportNodes.remove();
    }

    @Override
    protected Iterator<ReportNode> descendingIterator() {
        return this.reportNodes.get().descendingIterator();
    }
}

