/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.components;

import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DcBus;
import com.powsybl.iidm.network.DcLine;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.math.graph.GraphUtil;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractComponentsManager<C extends Component> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponentsManager.class);
    private final String label;
    private List<C> components;
    private final boolean ac;
    private final boolean dc;

    protected AbstractComponentsManager(String label, boolean ac, boolean dc) {
        this.label = Objects.requireNonNull(label);
        this.ac = ac;
        this.dc = dc;
    }

    public void invalidate() {
        this.components = null;
    }

    public void update() {
        int i;
        if (this.components != null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.reset();
        int num = 0;
        HashMap<String, Integer> busId2num = new HashMap<String, Integer>();
        ArrayList<Bus> num2AcBus = new ArrayList<Bus>();
        ArrayList<DcBus> num2DcBus = new ArrayList<DcBus>();
        if (this.ac) {
            for (Bus bus : this.getNetwork().getBusView().getBuses()) {
                num2AcBus.add(bus);
                busId2num.put(bus.getId(), num);
                ++num;
            }
        }
        int nbAcBuses = num2AcBus.size();
        if (this.dc) {
            for (DcBus dcBus : this.getNetwork().getDcBuses()) {
                num2DcBus.add(dcBus);
                busId2num.put(dcBus.getId(), num);
                ++num;
            }
        }
        TIntArrayList[] tIntArrayListArray = new TIntArrayList[num];
        for (int i2 = 0; i2 < tIntArrayListArray.length; ++i2) {
            tIntArrayListArray[i2] = new TIntArrayList(3);
        }
        this.fillAdjacencyList(busId2num, tIntArrayListArray);
        GraphUtil.ConnectedComponentsComputationResult result = GraphUtil.computeConnectedComponents((TIntArrayList[])tIntArrayListArray);
        this.components = new ArrayList<C>(result.getComponentSize().length);
        for (i = 0; i < result.getComponentSize().length; ++i) {
            this.components.add(this.createComponent(i, result.getComponentSize()[i]));
        }
        for (i = 0; i < result.getComponentNumber().length; ++i) {
            if (i < nbAcBuses) {
                Bus bus = (Bus)num2AcBus.get(i);
                this.setComponentNumber(bus, result.getComponentNumber()[i]);
                continue;
            }
            DcBus dcBus = (DcBus)num2DcBus.get(i - nbAcBuses);
            this.setComponentNumber(dcBus, result.getComponentNumber()[i]);
        }
        LOGGER.debug("{} components computed in {} ms", (Object)this.getComponentLabel(), (Object)(System.currentTimeMillis() - startTime));
    }

    public List<C> getConnectedComponents() {
        this.update();
        return this.components;
    }

    public C getComponent(int num) {
        return (C)(num != -1 ? (Component)this.components.get(num) : null);
    }

    private void addToAdjacencyList(Identifiable<?> bus1, Identifiable<?> bus2, Map<String, Integer> busId2num, TIntArrayList[] adjacencyList) {
        if (bus1 != null && bus2 != null) {
            int busNum1 = busId2num.get(bus1.getId());
            int busNum2 = busId2num.get(bus2.getId());
            adjacencyList[busNum1].add(busNum2);
            adjacencyList[busNum2].add(busNum1);
        }
    }

    private void fillAdjacencyList(Map<String, Integer> busId2num, TIntArrayList[] adjacencyList) {
        this.fillAcAdjacencyList(busId2num, adjacencyList);
        this.fillDcAdjacencyList(busId2num, adjacencyList);
        this.fillAcDcAdjacencyList(busId2num, adjacencyList);
    }

    private void fillAcAdjacencyList(Map<String, Integer> busId2num, TIntArrayList[] adjacencyList) {
        if (this.ac) {
            Bus bus2;
            Bus bus1;
            for (Line line : this.getNetwork().getLines()) {
                bus1 = line.getTerminal1().getBusView().getBus();
                bus2 = line.getTerminal2().getBusView().getBus();
                this.addToAdjacencyList(bus1, bus2, busId2num, adjacencyList);
            }
            for (TieLine tieLine : this.getNetwork().getTieLines()) {
                bus1 = tieLine.getDanglingLine1().getTerminal().getBusView().getBus();
                bus2 = tieLine.getDanglingLine2().getTerminal().getBusView().getBus();
                this.addToAdjacencyList(bus1, bus2, busId2num, adjacencyList);
            }
            for (TwoWindingsTransformer twoWindingsTransformer : this.getNetwork().getTwoWindingsTransformers()) {
                bus1 = twoWindingsTransformer.getTerminal1().getBusView().getBus();
                bus2 = twoWindingsTransformer.getTerminal2().getBusView().getBus();
                this.addToAdjacencyList(bus1, bus2, busId2num, adjacencyList);
            }
            for (ThreeWindingsTransformer threeWindingsTransformer : this.getNetwork().getThreeWindingsTransformers()) {
                bus1 = threeWindingsTransformer.getLeg1().getTerminal().getBusView().getBus();
                bus2 = threeWindingsTransformer.getLeg2().getTerminal().getBusView().getBus();
                Bus bus3 = threeWindingsTransformer.getLeg3().getTerminal().getBusView().getBus();
                this.addToAdjacencyList(bus1, bus2, busId2num, adjacencyList);
                this.addToAdjacencyList(bus1, bus3, busId2num, adjacencyList);
                this.addToAdjacencyList(bus2, bus3, busId2num, adjacencyList);
            }
        }
    }

    private void fillDcAdjacencyList(Map<String, Integer> busId2num, TIntArrayList[] adjacencyList) {
        if (this.dc) {
            DcBus dcBus2;
            DcBus dcBus1;
            for (DcLine dcLine : this.getNetwork().getDcLines()) {
                dcBus1 = dcLine.getDcTerminal1().getDcBus();
                dcBus2 = dcLine.getDcTerminal2().getDcBus();
                this.addToAdjacencyList(dcBus1, dcBus2, busId2num, adjacencyList);
            }
            for (AcDcConverter acDcConverter : this.getNetwork().getDcConnectables(AcDcConverter.class)) {
                dcBus1 = acDcConverter.getDcTerminal1().getDcBus();
                dcBus2 = acDcConverter.getDcTerminal2().getDcBus();
                this.addToAdjacencyList(dcBus1, dcBus2, busId2num, adjacencyList);
            }
        }
    }

    private void fillAcDcAdjacencyList(Map<String, Integer> busId2num, TIntArrayList[] adjacencyList) {
        if (this.ac && this.dc) {
            Bus bus1;
            for (HvdcLine line : this.getNetwork().getHvdcLines()) {
                bus1 = line.getConverterStation1().getTerminal().getBusView().getBus();
                Bus bus2 = line.getConverterStation2().getTerminal().getBusView().getBus();
                this.addToAdjacencyList(bus1, bus2, busId2num, adjacencyList);
            }
            for (AcDcConverter acDcConverter : this.getNetwork().getDcConnectables(AcDcConverter.class)) {
                bus1 = acDcConverter.getTerminal1().getBusView().getBus();
                DcBus dcBus1 = acDcConverter.getDcTerminal1().getDcBus();
                DcBus dcBus2 = acDcConverter.getDcTerminal2().getDcBus();
                this.addToAdjacencyList(bus1, dcBus1, busId2num, adjacencyList);
                this.addToAdjacencyList(bus1, dcBus2, busId2num, adjacencyList);
                acDcConverter.getTerminal2().ifPresent(t2 -> {
                    Bus bus2 = t2.getBusView().getBus();
                    this.addToAdjacencyList(bus1, bus2, busId2num, adjacencyList);
                    this.addToAdjacencyList(bus2, dcBus1, busId2num, adjacencyList);
                    this.addToAdjacencyList(bus2, dcBus2, busId2num, adjacencyList);
                });
            }
        }
    }

    private String getComponentLabel() {
        return this.label;
    }

    protected abstract Network getNetwork();

    protected abstract C createComponent(int var1, int var2);

    protected abstract void setComponentNumber(Bus var1, int var2);

    protected abstract void setComponentNumber(DcBus var1, int var2);

    private void reset() {
        if (this.ac) {
            for (Bus bus : this.getNetwork().getBusBreakerView().getBuses()) {
                this.setComponentNumber(bus, -1);
            }
        }
        if (this.dc) {
            for (DcBus dcBus : this.getNetwork().getDcBuses()) {
                this.setComponentNumber(dcBus, -1);
            }
        }
    }
}

