/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.limitmodification;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.limitmodification.AbstractLimitsComputerWithCache;
import com.powsybl.iidm.network.limitmodification.result.IdenticalLimitsContainer;
import com.powsybl.iidm.network.limitmodification.result.LimitsContainer;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import java.util.Optional;

public interface LimitsComputer<P, L> {
    public static final LimitsComputer<Identifiable<?>, LoadingLimits> NO_MODIFICATIONS = new NoModificationsImpl();

    public Optional<LimitsContainer<L>> computeLimits(P var1, LimitType var2, ThreeSides var3, boolean var4);

    public static class NoModificationsImpl
    extends AbstractLimitsComputerWithCache<Identifiable<?>, LoadingLimits> {
        @Override
        public Optional<LimitsContainer<LoadingLimits>> computeLimits(Identifiable<?> identifiable, LimitType limitType, ThreeSides side, boolean monitoringOnly) {
            Optional<LoadingLimits> limits = LimitViolationUtils.getLoadingLimits(identifiable, limitType, side);
            return limits.map(IdenticalLimitsContainer::new);
        }

        @Override
        protected Optional<LimitsContainer<LoadingLimits>> computeUncachedLimits(Identifiable<?> processable, LimitType limitType, ThreeSides side, boolean monitoringOnly) {
            throw new IllegalStateException("Not implemented: Should not be called");
        }
    }
}

