/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.tools;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DefaultDataSourceObserver;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Exporters;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.ImportersServiceLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolRunningContext;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@AutoService(value={Tool.class})
public class ConversionTool
implements Tool {
    private static final String INPUT_FILE = "input-file";
    private static final String OUTPUT_FORMAT = "output-format";
    private static final String OUTPUT_FILE = "output-file";

    protected ImportConfig createImportConfig() {
        return ImportConfig.load();
    }

    protected NetworkFactory createNetworkFactory() {
        return NetworkFactory.findDefault();
    }

    public Command getCommand() {
        return new Command(this){

            public String getName() {
                return "convert-network";
            }

            public String getTheme() {
                return "Data conversion";
            }

            public String getDescription() {
                return "convert a network from one format to another";
            }

            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt(ConversionTool.INPUT_FILE).desc("the input file").hasArg().argName("INPUT_FILE").required().build());
                options.addOption(Option.builder().longOpt(ConversionTool.OUTPUT_FORMAT).desc("the output file format").hasArg().argName("OUTPUT_FORMAT").required().build());
                options.addOption(Option.builder().longOpt(ConversionTool.OUTPUT_FILE).desc("the output file").hasArg().argName("OUTPUT_FILE").required().build());
                options.addOption(ConversionToolUtils.createImportParametersFileOption());
                options.addOption(ConversionToolUtils.createImportParameterOption());
                options.addOption(ConversionToolUtils.createExportParametersFileOption());
                options.addOption(ConversionToolUtils.createExportParameterOption());
                return options;
            }

            public String getUsageFooter() {
                return "Where OUTPUT_FORMAT is one of " + String.valueOf(Exporter.getFormats());
            }
        };
    }

    public void run(CommandLine line, final ToolRunningContext context) throws Exception {
        String inputFile = line.getOptionValue(INPUT_FILE);
        String outputFormat = line.getOptionValue(OUTPUT_FORMAT);
        String outputFile = line.getOptionValue(OUTPUT_FILE);
        Exporter exporter = Exporter.find(outputFormat);
        if (exporter == null) {
            throw new PowsyblException("Target format " + outputFormat + " not supported");
        }
        Properties inputParams = ConversionToolUtils.readProperties(line, ConversionToolUtils.OptionType.IMPORT, context);
        Network network = Network.read(context.getFileSystem().getPath(inputFile, new String[0]), context.getShortTimeExecutionComputationManager(), this.createImportConfig(), inputParams, this.createNetworkFactory(), (ImportersLoader)new ImportersServiceLoader(), ReportNode.NO_OP);
        Properties outputParams = ConversionToolUtils.readProperties(line, ConversionToolUtils.OptionType.EXPORT, context);
        DataSource ds2 = Exporters.createDataSource(context.getFileSystem().getPath(outputFile, new String[0]), (DataSourceObserver)new DefaultDataSourceObserver(this){

            public void opened(String streamName) {
                context.getOutputStream().println("Generating file " + streamName + "...");
            }
        });
        exporter.export(network, outputParams, ds2);
    }
}

