/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.tools;

import com.powsybl.tools.ToolRunningContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public final class ConversionToolUtils {
    private static final String IMPORT_PARAMETERS = "import-parameters";
    private static final String EXPORT_PARAMETERS = "export-parameters";

    public static Option createExportParameterOption() {
        return Option.builder((String)"E").desc("use value for given exporter parameter").argName("property=value").numberOfArgs(2).valueSeparator('=').build();
    }

    public static Option createImportParameterOption() {
        return Option.builder((String)"I").desc("use value for given importer parameter").argName("property=value").numberOfArgs(2).valueSeparator('=').build();
    }

    public static Option createExportParametersFileOption() {
        return Option.builder().longOpt(EXPORT_PARAMETERS).desc("the exporter configuration file").hasArg().argName("EXPORT_PARAMETERS").build();
    }

    public static Option createImportParametersFileOption() {
        return Option.builder().longOpt(IMPORT_PARAMETERS).desc("the importer configuration file").hasArg().argName("IMPORT_PARAMETERS").build();
    }

    public static Properties readProperties(CommandLine line, OptionType optionType, ToolRunningContext context) throws IOException {
        Properties properties = new Properties();
        String filename = line.getOptionValue(optionType.getLongOpt(), (Supplier)null);
        if (filename != null) {
            try (InputStream inputStream = Files.newInputStream(context.getFileSystem().getPath(filename, new String[0]), new OpenOption[0]);){
                if (filename.endsWith(".xml")) {
                    properties.loadFromXML(inputStream);
                } else {
                    properties.load(inputStream);
                }
            }
        }
        properties.putAll((Map<?, ?>)line.getOptionProperties(Character.toString(optionType.getShortOpt())));
        return properties;
    }

    private ConversionToolUtils() {
    }

    public static enum OptionType {
        IMPORT("import-parameters", 'I'),
        EXPORT("export-parameters", 'E');

        private final String longOpt;
        private final char shortOpt;

        private OptionType(String longOpt, char shortOpt) {
            this.longOpt = Objects.requireNonNull(longOpt);
            this.shortOpt = shortOpt;
        }

        char getShortOpt() {
            return this.shortOpt;
        }

        String getLongOpt() {
            return this.longOpt;
        }
    }
}

