/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.VscConverterStation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class HvdcUtils {
    public static double getConverterStationTargetP(HvdcConverterStation<?> station) {
        boolean disconnectedAtOtherSide = station.getOtherConverterStation().map(otherConverterStation -> {
            Bus bus = otherConverterStation.getTerminal().getBusView().getBus();
            return bus == null;
        }).orElse(true);
        return disconnectedAtOtherSide ? 0.0 : HvdcUtils.getSign(station) * HvdcUtils.getAbsoluteValuePAc(station);
    }

    public static double getLccConverterStationLoadTargetQ(LccConverterStation lccCs) {
        double pCs = HvdcUtils.getConverterStationTargetP(lccCs);
        return Math.abs(pCs * Math.tan(Math.acos(lccCs.getPowerFactor())));
    }

    public static double getSign(HvdcConverterStation<?> station) {
        double sign;
        boolean isConverterStationRectifier = HvdcUtils.isRectifier(station);
        if (station instanceof LccConverterStation) {
            sign = isConverterStationRectifier ? 1.0 : -1.0;
        } else if (station instanceof VscConverterStation) {
            sign = isConverterStationRectifier ? -1.0 : 1.0;
        } else {
            throw new PowsyblException("Unknown HVDC converter station type: " + station.getClass().getSimpleName());
        }
        return sign;
    }

    public static boolean isRectifier(HvdcConverterStation<?> station) {
        Objects.requireNonNull(station);
        HvdcLine line = station.getHvdcLine();
        return line.getConverterStation1() == station && line.getConvertersMode() == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER || line.getConverterStation2() == station && line.getConvertersMode() == HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
    }

    private static double getAbsoluteValuePAc(HvdcConverterStation<?> station) {
        boolean isConverterStationRectifier = HvdcUtils.isRectifier(station);
        if (isConverterStationRectifier) {
            return station.getHvdcLine().getActivePowerSetpoint();
        }
        AtomicReference<Double> absoluteValueInverterPAc = new AtomicReference<Double>(0.0);
        Optional<HvdcConverterStation<?>> otherStation = station.getOtherConverterStation();
        otherStation.ifPresent(os -> absoluteValueInverterPAc.set(HvdcUtils.getAbsoluteValueInverterPAc(os.getLossFactor(), station.getLossFactor(), station.getHvdcLine())));
        return absoluteValueInverterPAc.get();
    }

    public static double getHvdcLineLosses(double rectifierPDc, double nominalV, double r) {
        return r * rectifierPDc * rectifierPDc / (nominalV * nominalV);
    }

    private static double getAbsoluteValueInverterPAc(double rectifierLossFactor, double inverterLossFactor, HvdcLine hvdcLine) {
        double rectifierPDc = hvdcLine.getActivePowerSetpoint() * (1.0 - rectifierLossFactor / 100.0);
        double inverterPDc = rectifierPDc - HvdcUtils.getHvdcLineLosses(rectifierPDc, hvdcLine.getNominalV(), hvdcLine.getR());
        return inverterPDc * (1.0 - inverterLossFactor / 100.0);
    }

    private HvdcUtils() {
    }
}

