/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadingLimitsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingLimitsUtil.class);
    public static final Comparator<Integer> ACCEPTABLE_DURATION_COMPARATOR = (acceptableDuration1, acceptableDuration2) -> acceptableDuration2 - acceptableDuration1;

    private LoadingLimitsUtil() {
    }

    public static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> void fixMissingPermanentLimit(LoadingLimitsAdder<L, A> limitsAdder, double missingPermanentLimitPercentage) {
        LoadingLimitsUtil.fixMissingPermanentLimit(limitsAdder, missingPermanentLimitPercentage, "", LimitFixLogger.NO_OP);
    }

    public static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> void fixMissingPermanentLimit(LoadingLimitsAdder<L, A> adder, double missingPermanentLimitPercentage, String ownerId, LimitFixLogger limitFixLogger) {
        if (!Double.isNaN(adder.getPermanentLimit())) {
            return;
        }
        double lowestTemporaryLimitWithInfiniteAcceptableDuration = 2.147483647E9;
        boolean hasTemporaryLimitWithInfiniteAcceptableDuration = false;
        for (String name : adder.getTemporaryLimitNames()) {
            if (adder.getTemporaryLimitAcceptableDuration(name) != Integer.MAX_VALUE) continue;
            hasTemporaryLimitWithInfiniteAcceptableDuration = true;
            lowestTemporaryLimitWithInfiniteAcceptableDuration = Math.min(lowestTemporaryLimitWithInfiniteAcceptableDuration, adder.getTemporaryLimitValue(name));
            adder.removeTemporaryLimit(name);
        }
        if (hasTemporaryLimitWithInfiniteAcceptableDuration) {
            limitFixLogger.log("Operational Limits of " + ownerId, "Operational limits without permanent limit is considered with permanent limit equal to lowest temporary limit value with infinite acceptable duration", Double.NaN, lowestTemporaryLimitWithInfiniteAcceptableDuration);
            adder.setPermanentLimit(lowestTemporaryLimitWithInfiniteAcceptableDuration);
        } else {
            double firstTemporaryLimit = adder.getLowestTemporaryLimitValue();
            double percentage = missingPermanentLimitPercentage / 100.0;
            double fixedPermanentLimit = firstTemporaryLimit * percentage;
            limitFixLogger.log("Operational Limits of " + ownerId, "Operational limits without permanent limit is considered with permanent limit equal to lowest temporary limit value weighted by a coefficient of " + percentage + ".", Double.NaN, fixedPermanentLimit);
            adder.setPermanentLimit(fixedPermanentLimit);
        }
    }

    public static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> A initializeFromLoadingLimits(A adder, L limits) {
        if (limits == null) {
            LOGGER.warn("Created adder is empty");
            return adder;
        }
        adder.setPermanentLimit(limits.getPermanentLimit());
        limits.getTemporaryLimits().forEach(limit -> adder.beginTemporaryLimit().setName(limit.getName()).setAcceptableDuration(limit.getAcceptableDuration()).setValue(limit.getValue()).setFictitious(limit.isFictitious()).endTemporaryLimit());
        return adder;
    }

    public static <I extends Branch<I>> void copyOperationalLimits(I copiedBranch, I branch) {
        if (copiedBranch != null) {
            LoadingLimitsUtil.copyOperationalLimits(copiedBranch.getOperationalLimitsGroups1(), branch::newOperationalLimitsGroup1);
            copiedBranch.getSelectedOperationalLimitsGroupId1().ifPresent(branch::setSelectedOperationalLimitsGroup1);
            LoadingLimitsUtil.copyOperationalLimits(copiedBranch.getOperationalLimitsGroups2(), branch::newOperationalLimitsGroup2);
            copiedBranch.getSelectedOperationalLimitsGroupId2().ifPresent(branch::setSelectedOperationalLimitsGroup2);
        }
    }

    private static void copyOperationalLimits(Collection<OperationalLimitsGroup> from, Function<String, OperationalLimitsGroup> createGroup) {
        from.forEach(groupToCopy -> {
            OperationalLimitsGroup copy = (OperationalLimitsGroup)createGroup.apply(groupToCopy.getId());
            groupToCopy.getCurrentLimits().ifPresent(limit -> copy.newCurrentLimits((CurrentLimits)limit).add());
            groupToCopy.getActivePowerLimits().ifPresent(limit -> copy.newActivePowerLimits((ActivePowerLimits)limit).add());
            groupToCopy.getApparentPowerLimits().ifPresent(limit -> copy.newApparentPowerLimits((ApparentPowerLimits)limit).add());
        });
    }

    public static interface LimitFixLogger {
        public static final LimitFixLogger NO_OP = (what, reason, wrongValue, fixedValue) -> {};

        public void log(String var1, String var2, double var3, double var5);
    }
}

