/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Overload;
import java.util.Objects;

public class OverloadImpl
implements Overload {
    private final LoadingLimits.TemporaryLimit temporaryLimit;
    private final String previousLimitName;
    private final double previousLimit;
    private final double limitReductionCoefficient;
    private static final LoadingLimits.TemporaryLimit UNACCEPTABLE_LIMIT = new LoadingLimits.TemporaryLimit(){

        @Override
        public String getName() {
            return "Unacceptable";
        }

        @Override
        public double getValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public int getAcceptableDuration() {
            return 0;
        }

        @Override
        public boolean isFictitious() {
            return true;
        }
    };

    public OverloadImpl(LoadingLimits.TemporaryLimit temporaryLimit, String previousLimitName, double previousLimit) {
        this(temporaryLimit, previousLimitName, previousLimit, 1.0);
    }

    public OverloadImpl(String previousLimitName, double previousLimit, double limitReductionCoefficient) {
        this(UNACCEPTABLE_LIMIT, previousLimitName, previousLimit, limitReductionCoefficient);
    }

    public OverloadImpl(LoadingLimits.TemporaryLimit temporaryLimit, String previousLimitName, double previousLimit, double limitReductionCoefficient) {
        this.temporaryLimit = Objects.requireNonNull(temporaryLimit);
        this.previousLimitName = previousLimitName;
        this.previousLimit = previousLimit;
        this.limitReductionCoefficient = limitReductionCoefficient;
    }

    @Override
    public LoadingLimits.TemporaryLimit getTemporaryLimit() {
        return this.temporaryLimit;
    }

    @Override
    public String getPreviousLimitName() {
        return this.previousLimitName;
    }

    @Override
    public double getPreviousLimit() {
        return this.previousLimit;
    }

    @Override
    public double getLimitReductionCoefficient() {
        return this.limitReductionCoefficient;
    }
}

