/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import java.util.TreeMap;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReactiveCapabilityCurveUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveCapabilityCurveUtil.class);

    private ReactiveCapabilityCurveUtil() {
    }

    public static ReactiveCapabilityCurve.Point extrapolateReactiveLimitsSlope(double p, TreeMap<Double, ReactiveCapabilityCurve.Point> points, TriFunction<Double, Double, Double, ReactiveCapabilityCurve.Point> valuesToReactiveCapabilityPoint, String ownerDescription) {
        ReactiveCapabilityCurve.Point pbis;
        ReactiveCapabilityCurve.Point pBound;
        if (p < points.firstKey()) {
            pBound = points.firstEntry().getValue();
            pbis = points.higherEntry(points.firstKey()).getValue();
        } else if (p > points.lastKey()) {
            pBound = points.lastEntry().getValue();
            pbis = points.lowerEntry(points.lastKey()).getValue();
        } else {
            throw new IllegalStateException();
        }
        double slopeMinQ = (pbis.getMinQ() - pBound.getMinQ()) / (pbis.getP() - pBound.getP());
        double slopeMaxQ = (pbis.getMaxQ() - pBound.getMaxQ()) / (pbis.getP() - pBound.getP());
        double minQ = pBound.getMinQ() + slopeMinQ * (p - pBound.getP());
        double maxQ = pBound.getMaxQ() + slopeMaxQ * (p - pBound.getP());
        if (minQ <= maxQ) {
            return (ReactiveCapabilityCurve.Point)valuesToReactiveCapabilityPoint.apply((Object)p, (Object)minQ, (Object)maxQ);
        }
        double limitQ = (minQ + maxQ) / 2.0;
        LOGGER.warn("Extrapolation of reactive capability curve for {} leads to minQ > maxQ, correcting to minQ = maxQ", (Object)ownerDescription);
        return (ReactiveCapabilityCurve.Point)valuesToReactiveCapabilityPoint.apply((Object)p, (Object)limitQ, (Object)limitQ);
    }
}

