/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.spanning.KruskalMinimumSpanningTree;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class SwitchesFlow {
    private final VoltageLevel voltageLevel;
    private final Terminal slackTerminal;
    private final Map<String, SwFlow> switchesFlows;

    public SwitchesFlow(VoltageLevel voltageLevel) {
        this(voltageLevel, null);
    }

    public SwitchesFlow(VoltageLevel voltageLevel, Terminal slackTerminal) {
        this.voltageLevel = Objects.requireNonNull(voltageLevel);
        this.slackTerminal = slackTerminal;
        this.switchesFlows = new HashMap<String, SwFlow>();
        this.compute();
    }

    private void compute() {
        HashMap<String, SwNode> swNodeInjection = new HashMap<String, SwNode>();
        SimpleWeightedGraph graph = new SimpleWeightedGraph(SwEdge.class);
        this.buildGraph(swNodeInjection, (SimpleWeightedGraph<SwNode, SwEdge>)graph);
        this.calculateInjections(swNodeInjection);
        ConnectivityInspector ci = new ConnectivityInspector((Graph)graph);
        ci.connectedSets().forEach(connectedSet -> this.connectedComponentSwitchesFlow((Map<String, SwNode>)swNodeInjection, (SimpleWeightedGraph<SwNode, SwEdge>)graph, (Set<SwNode>)connectedSet));
        this.assignZeroFlowToEdgesOutsideAllTrees((SimpleWeightedGraph<SwNode, SwEdge>)graph);
    }

    public boolean isEmpty() {
        return this.switchesFlows.isEmpty();
    }

    public double getP1(String switchId) {
        if (this.switchesFlows.containsKey(switchId)) {
            return this.switchesFlows.get((Object)switchId).p1;
        }
        return 0.0;
    }

    public double getQ1(String switchId) {
        if (this.switchesFlows.containsKey(switchId)) {
            return this.switchesFlows.get((Object)switchId).q1;
        }
        return 0.0;
    }

    public double getP2(String switchId) {
        if (this.switchesFlows.containsKey(switchId)) {
            return this.switchesFlows.get((Object)switchId).p2;
        }
        return 0.0;
    }

    public double getQ2(String switchId) {
        if (this.switchesFlows.containsKey(switchId)) {
            return this.switchesFlows.get((Object)switchId).q2;
        }
        return 0.0;
    }

    private void buildGraph(Map<String, SwNode> swNodeInjection, SimpleWeightedGraph<SwNode, SwEdge> graph) {
        if (this.voltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER) {
            this.buildGraphFromNodeBreaker(swNodeInjection, graph);
        } else {
            this.buildGraphFromBusBreaker(swNodeInjection, graph);
        }
    }

    private void buildGraphFromNodeBreaker(Map<String, SwNode> swNodeInjection, SimpleWeightedGraph<SwNode, SwEdge> graph) {
        this.voltageLevel.getNodeBreakerView().getSwitches().forEach(sw -> {
            SwNode swNode2;
            if (sw.isOpen()) {
                return;
            }
            SwNode swNode1 = SwitchesFlow.addSwNode(swNodeInjection, this.voltageLevel.getNodeBreakerView().getNode1(sw.getId()));
            if (swNode1 == (swNode2 = SwitchesFlow.addSwNode(swNodeInjection, this.voltageLevel.getNodeBreakerView().getNode2(sw.getId())))) {
                return;
            }
            graph.addVertex((Object)swNode1);
            graph.addVertex((Object)swNode2);
            graph.addEdge((Object)swNode1, (Object)swNode2, (Object)new SwEdge((Switch)sw, swNode1, swNode2));
        });
        this.voltageLevel.getNodeBreakerView().getInternalConnections().forEach(ic -> {
            SwNode swNode1 = SwitchesFlow.addSwNode(swNodeInjection, ic.getNode1());
            SwNode swNode2 = SwitchesFlow.addSwNode(swNodeInjection, ic.getNode2());
            SwEdge swEdge = new SwEdge(swNode1, swNode2);
            if (swNode1 == swNode2) {
                return;
            }
            graph.addVertex((Object)swNode1);
            graph.addVertex((Object)swNode2);
            graph.addEdge((Object)swNode1, (Object)swNode2, (Object)swEdge);
        });
    }

    private void buildGraphFromBusBreaker(Map<String, SwNode> swNodeInjection, SimpleWeightedGraph<SwNode, SwEdge> graph) {
        this.voltageLevel.getBusBreakerView().getSwitches().forEach(sw -> {
            SwNode swNode2;
            if (sw.isOpen()) {
                return;
            }
            SwNode swNode1 = SwitchesFlow.addSwNode(swNodeInjection, this.voltageLevel.getBusBreakerView().getBus1(sw.getId()));
            if (swNode1 == (swNode2 = SwitchesFlow.addSwNode(swNodeInjection, this.voltageLevel.getBusBreakerView().getBus2(sw.getId())))) {
                return;
            }
            graph.addVertex((Object)swNode1);
            graph.addVertex((Object)swNode2);
            graph.addEdge((Object)swNode1, (Object)swNode2, (Object)new SwEdge((Switch)sw, swNode1, swNode2));
        });
    }

    private static SwNode addSwNode(Map<String, SwNode> swNodeInjection, int node) {
        if (swNodeInjection.containsKey(SwitchesFlow.getKey(node))) {
            return swNodeInjection.get(SwitchesFlow.getKey(node));
        }
        SwNode swNode = new SwNode(node);
        swNodeInjection.put(SwitchesFlow.getKey(node), swNode);
        return swNode;
    }

    private static SwNode addSwNode(Map<String, SwNode> swNodeInjection, Bus bus) {
        if (swNodeInjection.containsKey(SwitchesFlow.getKey(bus))) {
            return swNodeInjection.get(SwitchesFlow.getKey(bus));
        }
        SwNode swNode = new SwNode(bus);
        swNodeInjection.put(SwitchesFlow.getKey(bus), swNode);
        return swNode;
    }

    private void calculateInjections(Map<String, SwNode> swNodeInjection) {
        if (this.voltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER) {
            SwitchesFlow.calculateInjectionsNodeBreaker(this.voltageLevel, swNodeInjection);
        } else {
            SwitchesFlow.calculateInjectionsBusBreaker(this.voltageLevel, swNodeInjection);
        }
    }

    private static void calculateInjectionsNodeBreaker(VoltageLevel voltageLevel, Map<String, SwNode> swNodeInjection) {
        int[] nodes;
        for (int node : nodes = voltageLevel.getNodeBreakerView().getNodes()) {
            Terminal terminal = voltageLevel.getNodeBreakerView().getTerminal(node);
            if (terminal == null) continue;
            double p = SwitchesFlow.getTerminalP(terminal);
            double q = SwitchesFlow.getTerminalQ(terminal);
            swNodeInjection.computeIfPresent(SwitchesFlow.getKey(node), (key, value) -> value.addPQ(p, q));
        }
    }

    private static void calculateInjectionsBusBreaker(VoltageLevel voltageLevel, Map<String, SwNode> swNodeInjection) {
        voltageLevel.getBusBreakerView().getBuses().forEach(bus -> bus.getConnectedTerminals().forEach(terminal -> {
            double p = SwitchesFlow.getTerminalP(terminal);
            double q = SwitchesFlow.getTerminalQ(terminal);
            swNodeInjection.computeIfPresent(SwitchesFlow.getKey(bus), (key, value) -> value.addPQ(p, q));
        }));
    }

    private boolean isSlack(SwNode swNode) {
        if (this.voltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER) {
            return this.slackTerminal != null && swNode.node.intValue() == this.slackTerminal.getNodeBreakerView().getNode();
        }
        return this.slackTerminal != null && swNode.bus.equals(this.slackTerminal.getBusBreakerView().getBus());
    }

    private void connectedComponentSwitchesFlow(Map<String, SwNode> swNodeInjection, SimpleWeightedGraph<SwNode, SwEdge> graph, Set<SwNode> connectedSet) {
        if (connectedSet.size() <= 1) {
            return;
        }
        List<SwNode> sortedNodes = connectedSet.stream().sorted(Comparator.comparing(SwitchesFlow::getKey)).toList();
        Optional<SwNode> swRoot = sortedNodes.stream().filter(this::isSlack).findFirst().or(() -> sortedNodes.stream().findFirst());
        if (swRoot.isEmpty()) {
            return;
        }
        AsSubgraph subGraph = new AsSubgraph(graph, connectedSet);
        SpanningTreeAlgorithm.SpanningTree tree = new KruskalMinimumSpanningTree((Graph)subGraph).getSpanningTree();
        ArrayList<List<SwNode>> levels = new ArrayList<List<SwNode>>();
        HashMap<SwNode, SwEdge> parent = new HashMap<SwNode, SwEdge>();
        SwitchesFlow.buildLevels((SpanningTreeAlgorithm.SpanningTree<SwEdge>)tree, swRoot.get(), parent, levels);
        this.completeFlowsForEdgesInsideTree(swNodeInjection, parent, levels);
    }

    private static void buildLevels(SpanningTreeAlgorithm.SpanningTree<SwEdge> tree, SwNode swRoot, Map<SwNode, SwEdge> parent, List<List<SwNode>> levels) {
        HashSet processed = new HashSet();
        HashMap swEdgesInNode = new HashMap();
        tree.getEdges().forEach(e -> {
            swEdgesInNode.computeIfAbsent(e.swNode1, b -> new ArrayList()).add(e);
            swEdgesInNode.computeIfAbsent(e.swNode2, b -> new ArrayList()).add(e);
        });
        levels.add(new ArrayList<SwNode>(Collections.singleton(swRoot)));
        for (int level = 0; level < levels.size(); ++level) {
            ArrayList nextLevel = new ArrayList();
            levels.get(level).forEach(swNode -> ((List)swEdgesInNode.get(swNode)).forEach(e -> {
                SwNode other = SwitchesFlow.otherSwNode(e, swNode);
                if (other == null) {
                    return;
                }
                if (processed.contains(e)) {
                    return;
                }
                nextLevel.add(other);
                parent.put(other, (SwEdge)((Object)e));
                processed.add(e);
            }));
            if (nextLevel.isEmpty()) continue;
            levels.add(nextLevel);
        }
    }

    private void completeFlowsForEdgesInsideTree(Map<String, SwNode> swNodeInjection, Map<SwNode, SwEdge> parent, List<List<SwNode>> levels) {
        for (int level = levels.size() - 1; level >= 1; --level) {
            levels.get(level).forEach(swNode -> {
                double p = swNode.pflow + swNode.p;
                double q = swNode.qflow + swNode.q;
                SwEdge swEdge = (SwEdge)((Object)((Object)parent.get(swNode)));
                SwitchesFlow.addFlowToParentSwNode(swNodeInjection, SwitchesFlow.otherSwNode(swEdge, swNode), p, q);
                if (swEdge.isSwitch()) {
                    this.switchesFlows.computeIfAbsent(swEdge.getSwitchId(), k -> SwitchesFlow.calculateSwFlow(swEdge, swNode, p, q));
                }
            });
        }
    }

    private static void addFlowToParentSwNode(Map<String, SwNode> swNodeInjection, SwNode swNode, double p, double q) {
        swNodeInjection.computeIfPresent(SwitchesFlow.getKey(swNode), (key, value) -> value.addFlow(p, q));
    }

    private void assignZeroFlowToEdgesOutsideAllTrees(SimpleWeightedGraph<SwNode, SwEdge> graph) {
        graph.edgeSet().forEach(e -> {
            if (e.isSwitch() && !this.switchesFlows.containsKey(e.getSwitchId())) {
                this.switchesFlows.put(e.getSwitchId(), new SwFlow(0.0, 0.0, 0.0, 0.0));
            }
        });
    }

    private static SwFlow calculateSwFlow(SwEdge swEdge, SwNode swNode, double pOtherNode, double qOtherNode) {
        if (swEdge.swNode1 == swNode) {
            return new SwFlow(-pOtherNode, -qOtherNode, pOtherNode, qOtherNode);
        }
        return new SwFlow(pOtherNode, qOtherNode, -pOtherNode, -qOtherNode);
    }

    private static SwNode otherSwNode(SwEdge swEdge, SwNode swNode) {
        if (swEdge.swNode1 == swNode) {
            return swEdge.swNode2;
        }
        if (swEdge.swNode2 == swNode) {
            return swEdge.swNode1;
        }
        return null;
    }

    private static String getKey(int node) {
        return String.format("N-%d", node);
    }

    private static String getKey(Bus bus) {
        return String.format("B-%s", bus.getId());
    }

    private static String getKey(SwNode swNode) {
        if (swNode.isNodeBreaker()) {
            return SwitchesFlow.getKey(swNode.node);
        }
        return SwitchesFlow.getKey(swNode.bus);
    }

    private static double getTerminalP(Terminal terminal) {
        if (Double.isNaN(terminal.getP())) {
            return 0.0;
        }
        return terminal.getP();
    }

    private static double getTerminalQ(Terminal terminal) {
        if (Double.isNaN(terminal.getQ())) {
            return 0.0;
        }
        return terminal.getQ();
    }

    private static final class SwEdge
    extends DefaultWeightedEdge {
        private final transient Switch sw;
        private final transient SwNode swNode1;
        private final transient SwNode swNode2;

        private SwEdge(Switch sw, SwNode swNode1, SwNode swNode2) {
            this.sw = sw;
            this.swNode1 = swNode1;
            this.swNode2 = swNode2;
        }

        private SwEdge(SwNode swNode1, SwNode swNode2) {
            this.sw = null;
            this.swNode1 = swNode1;
            this.swNode2 = swNode2;
        }

        private boolean isSwitch() {
            return this.sw != null;
        }

        private String getSwitchId() {
            if (this.sw != null) {
                return this.sw.getId();
            }
            return null;
        }

        protected double getWeight() {
            return 0.0;
        }
    }

    private static final class SwFlow {
        private final double p1;
        private final double q1;
        private final double p2;
        private final double q2;

        private SwFlow(double p1, double q1, double p2, double q2) {
            this.p1 = p1;
            this.q1 = q1;
            this.p2 = p2;
            this.q2 = q2;
        }
    }

    private static final class SwNode {
        private final Integer node;
        private final Bus bus;
        private double p;
        private double q;
        private double pflow;
        private double qflow;

        private SwNode(int node) {
            this.node = node;
            this.bus = null;
        }

        private SwNode(Bus bus) {
            this.node = null;
            this.bus = bus;
        }

        private boolean isNodeBreaker() {
            return this.node != null;
        }

        private SwNode addPQ(double p, double q) {
            this.p += p;
            this.q += q;
            return this;
        }

        private SwNode addFlow(double pFlow, double qFlow) {
            this.pflow += pFlow;
            this.qflow += qFlow;
            return this;
        }
    }
}

