/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.export;

import com.google.common.collect.Sets;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.AbstractOptions;
import com.powsybl.iidm.network.TopologyLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportOptions
extends AbstractOptions<ExportOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportOptions.class);
    private boolean withBranchSV = true;
    private boolean indent = true;
    private boolean onlyMainCc = false;
    private boolean anonymized = false;
    private TopologyLevel topologyLevel = TopologyLevel.NODE_BREAKER;
    private boolean throwExceptionIfExtensionNotFound = false;
    private String version;
    private IidmVersionIncompatibilityBehavior iidmVersionIncompatibilityBehavior = IidmVersionIncompatibilityBehavior.THROW_EXCEPTION;
    private Map<String, String> extensionsVersions = new HashMap<String, String>();
    private boolean sorted = false;

    public ExportOptions() {
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, false);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, boolean sorted) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, sorted, null);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, String version) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, false, version);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, boolean sorted, String version) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, sorted, version, IidmVersionIncompatibilityBehavior.THROW_EXCEPTION);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, boolean sorted, String version, IidmVersionIncompatibilityBehavior iidmVersionIncompatibilityBehavior) {
        this.withBranchSV = withBranchSV;
        this.indent = indent;
        this.onlyMainCc = onlyMainCc;
        this.topologyLevel = Objects.requireNonNull(topologyLevel);
        this.throwExceptionIfExtensionNotFound = throwExceptionIfExtensionNotFound;
        this.sorted = sorted;
        this.version = version;
        this.iidmVersionIncompatibilityBehavior = Objects.requireNonNull(iidmVersionIncompatibilityBehavior);
    }

    @Override
    public ExportOptions addExtension(String extension) {
        if (this.extensions != null) {
            this.extensions.add(extension);
        } else {
            this.extensions = Sets.newHashSet((Object[])new String[]{extension});
        }
        return this;
    }

    public boolean isWithBranchSV() {
        return this.withBranchSV;
    }

    public ExportOptions setWithBranchSV(boolean withBranchSV) {
        this.withBranchSV = withBranchSV;
        return this;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public ExportOptions setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public boolean isOnlyMainCc() {
        return this.onlyMainCc;
    }

    public ExportOptions setOnlyMainCc(boolean onlyMainCc) {
        this.onlyMainCc = onlyMainCc;
        return this;
    }

    public boolean isAnonymized() {
        return this.anonymized;
    }

    public ExportOptions setAnonymized(boolean anonymized) {
        this.anonymized = anonymized;
        return this;
    }

    public TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public ExportOptions setTopologyLevel(TopologyLevel topologyLevel) {
        this.topologyLevel = Objects.requireNonNull(topologyLevel);
        return this;
    }

    @Override
    public ExportOptions setExtensions(Set<String> extensions) {
        Optional.ofNullable(this.extensions).ifPresent(e -> {
            if (e.isEmpty()) {
                LOGGER.warn("Extensions have already been set as empty. This call will override it.");
            }
        });
        this.extensions = extensions;
        return this;
    }

    @Override
    public boolean isThrowExceptionIfExtensionNotFound() {
        return this.throwExceptionIfExtensionNotFound;
    }

    public ExportOptions setThrowExceptionIfExtensionNotFound(boolean throwException) {
        this.throwExceptionIfExtensionNotFound = throwException;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ExportOptions setVersion(String version) {
        this.version = version;
        return this;
    }

    public IidmVersionIncompatibilityBehavior getIidmVersionIncompatibilityBehavior() {
        return this.iidmVersionIncompatibilityBehavior;
    }

    public ExportOptions setIidmVersionIncompatibilityBehavior(IidmVersionIncompatibilityBehavior iidmVersionIncompatibilityBehavior) {
        this.iidmVersionIncompatibilityBehavior = Objects.requireNonNull(iidmVersionIncompatibilityBehavior);
        return this;
    }

    public ExportOptions addExtensionVersion(String extensionName, String extensionVersion) {
        if (this.extensions != null && !this.extensions.contains(extensionName)) {
            throw new PowsyblException(extensionName + " is not an extension you have passed in the extensions list to export.");
        }
        if (this.extensionsVersions.putIfAbsent(extensionName, extensionVersion) != null) {
            throw new PowsyblException("The version of " + extensionName + "'s XML serializer has already been set.");
        }
        return this;
    }

    public Optional<String> getExtensionVersion(String extensionName) {
        return Optional.ofNullable(this.extensionsVersions.get(extensionName));
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public ExportOptions setSorted(boolean sorted) {
        this.sorted = sorted;
        return this;
    }

    public static enum IidmVersionIncompatibilityBehavior {
        THROW_EXCEPTION,
        LOG_ERROR;

    }
}

