/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.export;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.FileDataSource;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.iidm.export.Exporter;
import com.powsybl.iidm.export.ExportersLoader;
import com.powsybl.iidm.export.ExportersServiceLoader;
import com.powsybl.iidm.network.Network;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;

public final class Exporters {
    private static final Supplier<ExportersLoader> LOADER = Suppliers.memoize(ExportersServiceLoader::new);

    private Exporters() {
    }

    public static Collection<String> getFormats(ExportersLoader loader) {
        Objects.requireNonNull(loader);
        return loader.loadExporters().stream().map(Exporter::getFormat).collect(Collectors.toSet());
    }

    public static Collection<String> getFormats() {
        return Exporters.getFormats((ExportersLoader)LOADER.get());
    }

    public static Exporter getExporter(ExportersLoader loader, String format) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(loader);
        for (Exporter e : loader.loadExporters()) {
            if (!format.equals(e.getFormat())) continue;
            return e;
        }
        return null;
    }

    public static Exporter getExporter(String format) {
        return Exporters.getExporter((ExportersLoader)LOADER.get(), format);
    }

    public static DataSource createDataSource(Path directory, String fileNameOrBaseName, DataSourceObserver observer) {
        return DataSourceUtil.createDataSource((Path)directory, (String)fileNameOrBaseName, (DataSourceObserver)observer);
    }

    public static DataSource createDataSource(Path file, DataSourceObserver observer) {
        Objects.requireNonNull(file);
        if (Files.exists(file, new LinkOption[0]) && !Files.isRegularFile(file, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("File " + file + " already exists and is not a regular file"));
        }
        Path absFile = file.toAbsolutePath();
        return Exporters.createDataSource(absFile.getParent(), absFile.getFileName().toString(), observer);
    }

    public static DataSource createDataSource(Path file) {
        return Exporters.createDataSource(file, null);
    }

    public static void export(ExportersLoader loader, String format, Network network, Properties parameters, DataSource dataSource, Reporter reporter) {
        Exporter exporter = Exporters.getExporter(loader, format);
        if (exporter == null) {
            throw new PowsyblException("Export format " + format + " not supported");
        }
        exporter.export(network, parameters, dataSource, reporter);
    }

    public static void export(ExportersLoader loader, String format, Network network, Properties parameters, DataSource dataSource) {
        Exporters.export(loader, format, network, parameters, dataSource, Reporter.NO_OP);
    }

    public static void export(String format, Network network, Properties parameters, DataSource dataSource) {
        Exporters.export((ExportersLoader)LOADER.get(), format, network, parameters, dataSource);
    }

    public static void export(ExportersLoader loader, String format, Network network, Properties parameters, Path file, Reporter reporter) {
        DataSource dataSource = Exporters.createDataSource(file);
        Exporters.export(loader, format, network, parameters, dataSource, reporter);
    }

    public static void export(ExportersLoader loader, String format, Network network, Properties parameters, Path file) {
        Exporters.export(loader, format, network, parameters, file, Reporter.NO_OP);
    }

    public static void export(String format, Network network, Properties parameters, Path file) {
        Exporters.export((ExportersLoader)LOADER.get(), format, network, parameters, file);
    }

    public static void export(ExportersLoader loader, String format, Network network, Properties parameters, String directory, String baseName, Reporter reporter) {
        Exporters.export(loader, format, network, parameters, (DataSource)new FileDataSource(Paths.get(directory, new String[0]), baseName), reporter);
    }

    public static void export(ExportersLoader loader, String format, Network network, Properties parameters, String directory, String basename) {
        Exporters.export(loader, format, network, parameters, directory, basename, Reporter.NO_OP);
    }

    public static void export(String format, Network network, Properties parameters, String directory, String baseName) {
        Exporters.export((ExportersLoader)LOADER.get(), format, network, parameters, directory, baseName);
    }
}

