/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.import_;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.FileDataSource;
import com.powsybl.commons.datasource.GenericReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyMemDataSource;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.import_.ImportConfig;
import com.powsybl.iidm.import_.ImportPostProcessor;
import com.powsybl.iidm.import_.Importer;
import com.powsybl.iidm.import_.ImportersLoader;
import com.powsybl.iidm.import_.ImportersServiceLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.parameters.Parameter;
import com.powsybl.iidm.parameters.ParameterDefaultValueConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Importers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Importers.class);
    private static final Supplier<ImportersLoader> LOADER = Suppliers.memoize(ImportersServiceLoader::new);
    private static final Supplier<ImportConfig> CONFIG = Suppliers.memoize(ImportConfig::load);
    private static final String UNSUPPORTED_FILE_FORMAT_OR_INVALID_FILE = "Unsupported file format or invalid file.";

    private Importers() {
    }

    public static Collection<String> getFormats(ImportersLoader loader) {
        Objects.requireNonNull(loader);
        return loader.loadImporters().stream().map(Importer::getFormat).collect(Collectors.toSet());
    }

    public static Collection<String> getFormats() {
        return Importers.getFormats((ImportersLoader)LOADER.get());
    }

    private static Importer wrapImporter(ImportersLoader loader, Importer importer, ComputationManager computationManager, ImportConfig config) {
        Objects.requireNonNull(computationManager);
        Objects.requireNonNull(config);
        List<String> postProcessorNames = config.getPostProcessors();
        if (postProcessorNames != null && !postProcessorNames.isEmpty()) {
            return new ImporterWrapper(loader, importer, computationManager, postProcessorNames);
        }
        return importer;
    }

    public static Collection<Importer> list(ImportersLoader loader, ComputationManager computationManager, ImportConfig config) {
        Objects.requireNonNull(loader);
        return loader.loadImporters().stream().map(importer -> Importers.wrapImporter(loader, importer, computationManager, config)).collect(Collectors.toList());
    }

    public static Collection<Importer> list(ComputationManager computationManager, ImportConfig config) {
        return Importers.list((ImportersLoader)LOADER.get(), computationManager, config);
    }

    public static Collection<Importer> list() {
        return Importers.list(LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get());
    }

    public static Importer getImporter(ImportersLoader loader, String format, @Nullable ComputationManager computationManager, ImportConfig config) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(loader);
        for (Importer importer : loader.loadImporters()) {
            if (!format.equals(importer.getFormat())) continue;
            return Importers.wrapImporter(loader, importer, computationManager, config);
        }
        return null;
    }

    public static Importer getImporter(String format, @Nullable ComputationManager computationManager, ImportConfig config) {
        return Importers.getImporter((ImportersLoader)LOADER.get(), format, computationManager, config);
    }

    public static Importer getImporter(String format, @Nullable ComputationManager computationManager) {
        return Importers.getImporter(format, computationManager, (ImportConfig)CONFIG.get());
    }

    public static Importer getImporter(String format) {
        return Importers.getImporter(format, LocalComputationManager.getDefault());
    }

    public static Collection<String> getPostProcessorNames(ImportersLoader loader) {
        Objects.requireNonNull(loader);
        return loader.loadPostProcessors().stream().map(ImportPostProcessor::getName).collect(Collectors.toList());
    }

    public static Collection<String> getPostProcessorNames() {
        return Importers.getPostProcessorNames((ImportersLoader)LOADER.get());
    }

    public static Importer addPostProcessors(ImportersLoader loader, Importer importer, ComputationManager computationManager, String ... names) {
        return new ImporterWrapper(loader, importer, computationManager, Arrays.asList(names));
    }

    public static Importer addPostProcessors(Importer importer, ComputationManager computationManager, String ... names) {
        return Importers.addPostProcessors((ImportersLoader)LOADER.get(), importer, computationManager, names);
    }

    public static Importer addPostProcessors(Importer importer, String ... names) {
        return Importers.addPostProcessors(importer, LocalComputationManager.getDefault(), names);
    }

    public static Importer setPostProcessors(ImportersLoader loader, Importer importer, ComputationManager computationManager, String ... names) {
        Importer importer2 = Importers.removePostProcessors(importer);
        return Importers.addPostProcessors(loader, importer2, computationManager, names);
    }

    public static Importer setPostProcessors(Importer importer, ComputationManager computationManager, String ... names) {
        return Importers.setPostProcessors((ImportersLoader)LOADER.get(), importer, computationManager, names);
    }

    public static Importer setPostProcessors(Importer importer, String ... names) {
        return Importers.setPostProcessors(importer, LocalComputationManager.getDefault(), names);
    }

    public static Importer removePostProcessors(Importer importer) {
        Objects.requireNonNull(importer);
        if (importer instanceof ImporterWrapper) {
            return Importers.removePostProcessors(((ImporterWrapper)importer).getImporter());
        }
        return importer;
    }

    public static Network importData(ImportersLoader loader, String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager, ImportConfig config, Reporter reporter) {
        Importer importer = Importers.getImporter(loader, format, computationManager, config);
        if (importer == null) {
            throw new PowsyblException("Import format " + format + " not supported");
        }
        return importer.importData(dataSource, NetworkFactory.findDefault(), parameters, reporter);
    }

    public static Network importData(ImportersLoader loader, String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager, ImportConfig config) {
        return Importers.importData(loader, format, dataSource, parameters, computationManager, config, Reporter.NO_OP);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager, Reporter reporter) {
        return Importers.importData((ImportersLoader)LOADER.get(), format, dataSource, parameters, computationManager, (ImportConfig)CONFIG.get(), reporter);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager) {
        return Importers.importData((ImportersLoader)LOADER.get(), format, dataSource, parameters, computationManager, (ImportConfig)CONFIG.get(), Reporter.NO_OP);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters, Reporter reporter) {
        return Importers.importData((ImportersLoader)LOADER.get(), format, dataSource, parameters, LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get(), reporter);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters) {
        return Importers.importData(format, dataSource, parameters, LocalComputationManager.getDefault());
    }

    public static Network importData(String format, String directory, String baseName, Properties parameters) {
        return Importers.importData(format, (ReadOnlyDataSource)new FileDataSource(Paths.get(directory, new String[0]), baseName), parameters);
    }

    private static void doImport(ReadOnlyDataSource dataSource, Importer importer, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, Reporter reporter) {
        Objects.requireNonNull(consumer);
        try {
            if (listener != null) {
                listener.accept(dataSource);
            }
            Network network = importer.importData(dataSource, NetworkFactory.findDefault(), parameters, reporter);
            consumer.accept(network);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    private static void addDataSource(Path dir, Path file, Importer importer, List<ReadOnlyDataSource> dataSources) {
        Objects.requireNonNull(importer);
        String caseBaseName = DataSourceUtil.getBaseName((Path)file);
        GenericReadOnlyDataSource ds = new GenericReadOnlyDataSource(dir, caseBaseName);
        if (importer.exists((ReadOnlyDataSource)ds)) {
            dataSources.add((ReadOnlyDataSource)ds);
        }
    }

    private static void importAll(Path parent, Importer importer, List<ReadOnlyDataSource> dataSources) throws IOException {
        if (Files.isDirectory(parent, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(parent);){
                stream.sorted().forEach(child -> {
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        try {
                            Importers.importAll(child, importer, dataSources);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    } else {
                        Importers.addDataSource(parent, child, importer, dataSources);
                    }
                });
            }
        } else if (parent.getParent() != null) {
            Importers.addDataSource(parent.getParent(), parent, importer, dataSources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importAll(Path dir, Importer importer, boolean parallel, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, Reporter reporter) throws IOException, InterruptedException, ExecutionException {
        ArrayList<ReadOnlyDataSource> dataSources = new ArrayList<ReadOnlyDataSource>();
        Importers.importAll(dir, importer, dataSources);
        if (parallel) {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                List futures = dataSources.stream().map(ds -> {
                    Reporter child = Importers.createSubReporter(reporter, ds);
                    return executor.submit(() -> Importers.doImport(ds, importer, parameters, consumer, listener, child));
                }).collect(Collectors.toList());
                for (Future future : futures) {
                    future.get();
                }
            }
            finally {
                executor.shutdownNow();
            }
        } else {
            for (ReadOnlyDataSource dataSource : dataSources) {
                Importers.doImport(dataSource, importer, parameters, consumer, listener, Importers.createSubReporter(reporter, dataSource));
            }
        }
    }

    private static Reporter createSubReporter(Reporter reporter, ReadOnlyDataSource ds) {
        return reporter.createSubReporter("importDataSource", "Import data source ${dataSource}", "dataSource", (Object)ds.getBaseName());
    }

    public static void importAll(Path dir, Importer importer, boolean parallel, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.importAll(dir, importer, parallel, null, consumer, listener, Reporter.NO_OP);
    }

    public static void importAll(Path dir, Importer importer, boolean parallel, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Importers.importAll(dir, importer, parallel, consumer, null);
    }

    @Deprecated
    public static Object readParameter(String format, Properties parameters, Parameter configuredParameter) {
        return Parameter.read(format, parameters, configuredParameter);
    }

    @Deprecated
    public static Object readParameter(String format, Properties parameters, Parameter configuredParameter, ParameterDefaultValueConfig defaultValueConfig) {
        return Parameter.read(format, parameters, configuredParameter, defaultValueConfig);
    }

    public static DataSource createDataSource(Path file) {
        Objects.requireNonNull(file);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new PowsyblException("File " + file + " does not exist or is not a regular file");
        }
        Path absFile = file.toAbsolutePath();
        return Importers.createDataSource(absFile.getParent(), absFile.getFileName().toString());
    }

    public static DataSource createDataSource(Path directory, String fileNameOrBaseName) {
        return DataSourceUtil.createDataSource((Path)directory, (String)fileNameOrBaseName, null);
    }

    public static Importer findImporter(ReadOnlyDataSource dataSource, ImportersLoader loader, ComputationManager computationManager, ImportConfig config) {
        for (Importer importer : Importers.list(loader, computationManager, config)) {
            if (!importer.exists(dataSource)) continue;
            return importer;
        }
        return null;
    }

    public static Importer findImporter(ReadOnlyDataSource dataSource, ComputationManager computationManager) {
        return Importers.findImporter(dataSource, (ImportersLoader)LOADER.get(), computationManager, (ImportConfig)CONFIG.get());
    }

    public static Importer findImporter(ReadOnlyDataSource dataSource) {
        return Importers.findImporter(dataSource, LocalComputationManager.getDefault());
    }

    public static Network loadNetwork(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader, Reporter reporter) {
        DataSource dataSource = Importers.createDataSource(file);
        Importer importer = Importers.findImporter((ReadOnlyDataSource)dataSource, loader, computationManager, config);
        if (importer != null) {
            return importer.importData((ReadOnlyDataSource)dataSource, NetworkFactory.findDefault(), parameters, reporter);
        }
        throw new PowsyblException(UNSUPPORTED_FILE_FORMAT_OR_INVALID_FILE);
    }

    public static Network loadNetwork(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader) {
        return Importers.loadNetwork(file, computationManager, config, parameters, loader, Reporter.NO_OP);
    }

    public static Network loadNetwork(Path file, ComputationManager computationManager, ImportConfig config, Properties parameters) {
        return Importers.loadNetwork(file, computationManager, config, parameters, (ImportersLoader)LOADER.get());
    }

    public static Network loadNetwork(Path file) {
        return Importers.loadNetwork(file, LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get(), null);
    }

    public static Network loadNetwork(String file) {
        return Importers.loadNetwork(Paths.get(file, new String[0]));
    }

    public static Network loadNetwork(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader, Reporter reporter) {
        ReadOnlyMemDataSource dataSource = new ReadOnlyMemDataSource(DataSourceUtil.getBaseName((String)filename));
        dataSource.putData(filename, data);
        Importer importer = Importers.findImporter((ReadOnlyDataSource)dataSource, loader, computationManager, config);
        if (importer != null) {
            return importer.importData((ReadOnlyDataSource)dataSource, NetworkFactory.findDefault(), parameters, reporter);
        }
        throw new PowsyblException(UNSUPPORTED_FILE_FORMAT_OR_INVALID_FILE);
    }

    public static Network loadNetwork(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters, ImportersLoader loader) {
        return Importers.loadNetwork(filename, data, computationManager, config, parameters, loader, Reporter.NO_OP);
    }

    public static Network loadNetwork(String filename, InputStream data, ComputationManager computationManager, ImportConfig config, Properties parameters) {
        return Importers.loadNetwork(filename, data, computationManager, config, parameters, (ImportersLoader)LOADER.get());
    }

    public static Network loadNetwork(String filename, InputStream data, ComputationManager computationManager) {
        return Importers.loadNetwork(filename, data, computationManager, (ImportConfig)CONFIG.get(), null);
    }

    public static Network loadNetwork(String filename, InputStream data) {
        return Importers.loadNetwork(filename, data, LocalComputationManager.getDefault());
    }

    public static Network loadNetwork(String filename, InputStream data, Reporter reporter) {
        return Importers.loadNetwork(filename, data, LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get(), null, (ImportersLoader)LOADER.get(), reporter);
    }

    public static Network loadNetwork(ReadOnlyDataSource dataSource) {
        return Importers.loadNetwork(dataSource, null);
    }

    public static Network loadNetwork(ReadOnlyDataSource dataSource, Properties properties) {
        return Importers.loadNetwork(dataSource, properties, Reporter.NO_OP);
    }

    public static Network loadNetwork(ReadOnlyDataSource dataSource, Properties properties, Reporter reporter) {
        Importer importer = Importers.findImporter(dataSource);
        if (importer != null) {
            return importer.importData(dataSource, NetworkFactory.findDefault(), properties, reporter);
        }
        throw new PowsyblException(UNSUPPORTED_FILE_FORMAT_OR_INVALID_FILE);
    }

    public static void loadNetworks(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, Reporter reporter) throws IOException, InterruptedException, ExecutionException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new PowsyblException("Directory " + dir + " does not exist or is not a regular directory");
        }
        for (Importer importer : Importers.list(loader, computationManager, config)) {
            Importers.importAll(dir, importer, parallel, parameters, consumer, listener, reporter);
        }
    }

    public static void loadNetworks(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, loader, computationManager, config, parameters, consumer, listener, Reporter.NO_OP);
    }

    public static void loadNetworks(Path dir, boolean parallel, ImportersLoader loader, ComputationManager computationManager, ImportConfig config, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, loader, computationManager, config, null, consumer, listener);
    }

    public static void loadNetworks(Path dir, boolean parallel, ComputationManager computationManager, ImportConfig config, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, (ImportersLoader)LOADER.get(), computationManager, config, parameters, consumer, listener);
    }

    public static void loadNetworks(Path dir, boolean parallel, ComputationManager computationManager, ImportConfig config, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, (ImportersLoader)LOADER.get(), computationManager, config, consumer, listener);
    }

    public static void loadNetworks(Path dir, boolean parallel, ComputationManager computationManager, ImportConfig config, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, computationManager, config, consumer, null);
    }

    public static void loadNetworks(Path dir, boolean parallel, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get(), consumer);
    }

    public static void loadNetworks(Path dir, boolean parallel, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, parallel, LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get(), consumer, listener);
    }

    public static void loadNetworks(Path dir, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Importers.loadNetworks(dir, false, LocalComputationManager.getDefault(), (ImportConfig)CONFIG.get(), consumer);
    }

    private static class ImporterWrapper
    implements Importer {
        private final Importer importer;
        private final ComputationManager computationManager;
        private final List<String> names;
        private final ImportersLoader loader;

        ImporterWrapper(ImportersLoader loader, Importer importer, ComputationManager computationManager, List<String> names) {
            this.loader = Objects.requireNonNull(loader);
            this.importer = importer;
            this.computationManager = computationManager;
            this.names = names;
        }

        public Importer getImporter() {
            return this.importer;
        }

        @Override
        public String getFormat() {
            return this.importer.getFormat();
        }

        @Override
        public List<Parameter> getParameters() {
            return this.importer.getParameters();
        }

        @Override
        public String getComment() {
            return this.importer.getComment();
        }

        @Override
        public boolean exists(ReadOnlyDataSource dataSource) {
            return this.importer.exists(dataSource);
        }

        private static ImportPostProcessor getPostProcessor(ImportersLoader loader, String name) {
            for (ImportPostProcessor ipp : loader.loadPostProcessors()) {
                if (!ipp.getName().equals(name)) continue;
                return ipp;
            }
            throw new PowsyblException("Post processor " + name + " not found");
        }

        @Override
        public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters, Reporter reporter) {
            Network network = this.importer.importData(dataSource, networkFactory, parameters, reporter);
            for (String name : this.names) {
                try {
                    ImporterWrapper.getPostProcessor(this.loader, name).process(network, this.computationManager, reporter);
                }
                catch (Exception e) {
                    throw new PowsyblException((Throwable)e);
                }
            }
            return network;
        }

        @Override
        public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters) {
            return this.importData(dataSource, networkFactory, parameters, Reporter.NO_OP);
        }

        @Override
        public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
            this.importer.copy(fromDataSource, toDataSource);
        }
    }
}

