/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.parameters;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.MapModuleConfig;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.ModuleConfigUtil;
import com.powsybl.iidm.parameters.ParameterDefaultValueConfig;
import com.powsybl.iidm.parameters.ParameterType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class Parameter {
    private final List<String> names = new ArrayList<String>();
    private final ParameterType type;
    private final String description;
    private final Object defaultValue;
    private final List<Object> possibleValues;

    public Parameter(String name, ParameterType type, String description, Object defaultValue, List<Object> possibleValues) {
        this.names.add(Objects.requireNonNull(name));
        this.type = Objects.requireNonNull(type);
        this.description = Objects.requireNonNull(description);
        this.defaultValue = Parameter.checkDefaultValue(type, defaultValue);
        this.possibleValues = Parameter.checkPossibleValues(type, possibleValues, defaultValue);
    }

    public Parameter(String name, ParameterType type, String description, Object defaultValue) {
        this(name, type, description, defaultValue, null);
    }

    private static void checkValue(Class<?> typeClass, Object value) {
        if (value != null && !typeClass.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Bad default value type " + value.getClass() + ", " + typeClass + " was expected");
        }
    }

    private static void checkPossibleValuesContainsValue(List<Object> possibleValues, Object value, Function<Object, IllegalArgumentException> exceptionCreator) {
        Objects.requireNonNull(possibleValues);
        Objects.requireNonNull(exceptionCreator);
        if (value != null) {
            if (value instanceof List) {
                for (Object valueElement : (List)value) {
                    if (possibleValues.contains(valueElement)) continue;
                    throw exceptionCreator.apply(valueElement);
                }
            } else if (!possibleValues.contains(value)) {
                throw exceptionCreator.apply(value);
            }
        }
    }

    private static List<Object> checkPossibleValues(ParameterType type, List<Object> possibleValues, Object defaultValue) {
        if (possibleValues != null) {
            possibleValues.forEach(value -> Parameter.checkValue(type.getElementClass(), value));
            Parameter.checkPossibleValuesContainsValue(possibleValues, defaultValue, v -> {
                throw new IllegalArgumentException("Parameter possible values " + possibleValues + " should contain default value " + v);
            });
        }
        return possibleValues;
    }

    private static Object checkDefaultValue(ParameterType type, Object defaultValue) {
        Parameter.checkValue(type.getTypeClass(), defaultValue);
        if (type == ParameterType.BOOLEAN && defaultValue == null) {
            throw new PowsyblException("With Boolean parameter you are not allowed to pass a null default value");
        }
        if (type == ParameterType.DOUBLE && defaultValue == null) {
            throw new PowsyblException("With Double parameter you are not allowed to pass a null default value");
        }
        return defaultValue;
    }

    public static Object read(String format, Properties parameters, Parameter configuredParameter, ParameterDefaultValueConfig defaultValueConfig) {
        Objects.requireNonNull(configuredParameter);
        switch (configuredParameter.getType()) {
            case BOOLEAN: {
                return Parameter.readBoolean(format, parameters, configuredParameter, defaultValueConfig);
            }
            case STRING: {
                return Parameter.readString(format, parameters, configuredParameter, defaultValueConfig);
            }
            case STRING_LIST: {
                return Parameter.readStringList(format, parameters, configuredParameter, defaultValueConfig);
            }
            case DOUBLE: {
                return Parameter.readDouble(format, parameters, configuredParameter, defaultValueConfig);
            }
        }
        throw new IllegalStateException("Unknown parameter type: " + configuredParameter.getType());
    }

    public static Object read(String format, Properties paramaters, Parameter configuredParameter) {
        return Parameter.read(format, paramaters, configuredParameter, ParameterDefaultValueConfig.INSTANCE);
    }

    public static boolean readBoolean(String format, Properties parameters, Parameter configuredParameter, ParameterDefaultValueConfig defaultValueConfig) {
        return Parameter.read(format, parameters, configuredParameter, defaultValueConfig.getBooleanValue(format, configuredParameter), ModuleConfigUtil::getOptionalBooleanProperty);
    }

    public static boolean readBoolean(String format, Properties parameters, Parameter configuredParameter) {
        return Parameter.readBoolean(format, parameters, configuredParameter, ParameterDefaultValueConfig.INSTANCE);
    }

    public static String readString(String format, Properties parameters, Parameter configuredParameter, ParameterDefaultValueConfig defaultValueConfig) {
        return Parameter.read(format, parameters, configuredParameter, defaultValueConfig.getStringValue(format, configuredParameter), ModuleConfigUtil::getOptionalStringProperty);
    }

    public static String readString(String format, Properties parameters, Parameter configuredParameter) {
        return Parameter.readString(format, parameters, configuredParameter, ParameterDefaultValueConfig.INSTANCE);
    }

    public static List<String> readStringList(String format, Properties parameters, Parameter configuredParameter, ParameterDefaultValueConfig defaultValueConfig) {
        return Parameter.read(format, parameters, configuredParameter, defaultValueConfig.getStringListValue(format, configuredParameter), ModuleConfigUtil::getOptionalStringListProperty);
    }

    public static List<String> readStringList(String format, Properties parameters, Parameter configuredParameter) {
        return Parameter.readStringList(format, parameters, configuredParameter, ParameterDefaultValueConfig.INSTANCE);
    }

    public static double readDouble(String format, Properties parameters, Parameter configuredParameter, ParameterDefaultValueConfig defaultValueConfig) {
        return Parameter.read(format, parameters, configuredParameter, defaultValueConfig.getDoubleValue(format, configuredParameter), (moduleConfig, names) -> ModuleConfigUtil.getOptionalDoubleProperty((ModuleConfig)moduleConfig, (List)names).orElse(Double.NaN), value -> !Double.isNaN(value));
    }

    public static double readDouble(String format, Properties parameters, Parameter configuredParameter) {
        return Parameter.readDouble(format, parameters, configuredParameter, ParameterDefaultValueConfig.INSTANCE);
    }

    private static <T> T read(String format, Properties parameters, Parameter configuredParameter, T defaultValue, BiFunction<ModuleConfig, List<String>, T> supplier, Predicate<T> isPresent) {
        MapModuleConfig moduleConfig;
        Objects.requireNonNull(format);
        Objects.requireNonNull(configuredParameter);
        T value = null;
        if (parameters != null && (value = (T)supplier.apply((ModuleConfig)(moduleConfig = new MapModuleConfig((Map)parameters)), configuredParameter.getNames())) != null && configuredParameter.getPossibleValues() != null) {
            Parameter.checkPossibleValuesContainsValue(configuredParameter.getPossibleValues(), value, v -> new IllegalArgumentException("Value " + v + " of parameter " + configuredParameter.getName() + " is not contained in possible values " + configuredParameter.getPossibleValues()));
        }
        if (isPresent.test(value)) {
            return value;
        }
        return defaultValue;
    }

    private static <T> T read(String format, Properties parameters, Parameter configuredParameter, T defaultValue, BiFunction<ModuleConfig, List<String>, Optional<T>> supplier) {
        return (T)Parameter.read(format, parameters, configuredParameter, defaultValue, (moduleConfig, strings) -> ((Optional)supplier.apply((ModuleConfig)moduleConfig, (List<String>)strings)).orElse(null), Objects::nonNull);
    }

    public Parameter addAdditionalNames(String ... names) {
        Objects.requireNonNull(names);
        this.names.addAll(Arrays.asList(names));
        return this;
    }

    public String getName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    public ParameterType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public List<Object> getPossibleValues() {
        return this.possibleValues;
    }
}

