/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.parameters;

import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.parameters.Parameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public class ParameterDefaultValueConfig {
    private static final String MODULE_NAME = "import-export-parameters-default-value";
    public static final ParameterDefaultValueConfig INSTANCE = new ParameterDefaultValueConfig();
    private PlatformConfig platformConfig;
    private boolean init = false;
    private ModuleConfig configCache;

    public ParameterDefaultValueConfig() {
        this(null);
    }

    public ParameterDefaultValueConfig(PlatformConfig platformConfig) {
        this.platformConfig = platformConfig;
    }

    private synchronized ModuleConfig getModuleConfig() {
        if (!this.init) {
            if (this.platformConfig == null) {
                this.platformConfig = PlatformConfig.defaultConfig();
            }
            this.configCache = this.platformConfig.getOptionalModuleConfig(MODULE_NAME).orElse(null);
            this.init = true;
        }
        return this.configCache;
    }

    public Object getValue(String format, Parameter parameter) {
        Objects.requireNonNull(parameter);
        switch (parameter.getType()) {
            case BOOLEAN: {
                return this.getBooleanValue(format, parameter);
            }
            case STRING: {
                return this.getStringValue(format, parameter);
            }
            case STRING_LIST: {
                return this.getStringListValue(format, parameter);
            }
            case DOUBLE: {
                return this.getDoubleValue(format, parameter);
            }
        }
        throw new IllegalStateException("Unsupported parameter type: " + parameter.getType());
    }

    public boolean getBooleanValue(String format, Parameter parameter) {
        return this.getValue(format, (Boolean)parameter.getDefaultValue(), parameter, ModuleConfig::getOptionalBooleanProperty);
    }

    public String getStringValue(String format, Parameter parameter) {
        return this.getValue(format, (String)parameter.getDefaultValue(), parameter, ModuleConfig::getOptionalStringProperty);
    }

    public List<String> getStringListValue(String format, Parameter parameter) {
        return this.getValue(format, (List)parameter.getDefaultValue(), parameter, ModuleConfig::getOptionalStringListProperty);
    }

    public double getDoubleValue(String format, Parameter parameter) {
        return this.getValue(format, (Double)parameter.getDefaultValue(), parameter, (moduleConfig, name) -> moduleConfig.getOptionalDoubleProperty(name).stream().boxed().findFirst());
    }

    private <T> T getValue(String format, T defaultValue, Parameter parameter, BiFunction<ModuleConfig, String, Optional<T>> valueSupplier) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(parameter);
        ModuleConfig moduleConfig = this.getModuleConfig();
        if (moduleConfig != null) {
            for (String name : parameter.getNames()) {
                Object value = valueSupplier.apply(moduleConfig, name).orElseGet(() -> ((Optional)valueSupplier.apply(moduleConfig, format + "_" + name)).orElse(null));
                if (value == null) continue;
                return (T)value;
            }
        }
        return defaultValue;
    }
}

