/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.google.common.collect.ImmutableList;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.SingleCountryCriterion;
import com.powsybl.iidm.criteria.TwoCountriesCriterion;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AtLeastOneCountryCriterion
implements Criterion {
    private final List<Country> countries;

    public AtLeastOneCountryCriterion(List<Country> countries) {
        Objects.requireNonNull(countries);
        this.countries = ImmutableList.copyOf(countries);
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.AT_LEAST_ONE_COUNTRY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        return this.filterWithCountries(this.getCountriesToCheck(identifiable, type));
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        return this.filterWithCountries(this.getCountriesToCheck(networkElement));
    }

    public List<Country> getCountries() {
        return this.countries;
    }

    private List<Country> getCountriesToCheck(Identifiable<?> identifiable, IdentifiableType type) {
        if (type == IdentifiableType.LINE || type == IdentifiableType.HVDC_LINE || type == IdentifiableType.TIE_LINE) {
            return TwoCountriesCriterion.getCountries(identifiable, type);
        }
        return Collections.singletonList(SingleCountryCriterion.getCountry(identifiable, type));
    }

    private List<Country> getCountriesToCheck(NetworkElement networkElement) {
        return Arrays.asList(networkElement.getCountry1().orElse(null), networkElement.getCountry2().orElse(null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean filterWithCountries(List<Country> countriesToCheck) {
        if (this.countries.isEmpty()) return true;
        if (!countriesToCheck.stream().filter(Objects::nonNull).anyMatch(this.countries::contains)) return false;
        return true;
    }
}

