/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.SingleNominalVoltageCriterion;
import com.powsybl.iidm.criteria.ThreeNominalVoltageCriterion;
import com.powsybl.iidm.criteria.TwoNominalVoltageCriterion;
import com.powsybl.iidm.criteria.VoltageInterval;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AtLeastOneNominalVoltageCriterion
implements Criterion {
    private final VoltageInterval voltageInterval;

    public AtLeastOneNominalVoltageCriterion(VoltageInterval voltageInterval) {
        this.voltageInterval = Objects.requireNonNull(voltageInterval);
    }

    @Override
    @JsonIgnore
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.AT_LEAST_ONE_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        return this.filterNominalVoltages(this.getNominalVoltagesToCheck(identifiable, type));
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        return this.filterNominalVoltages(this.getNominalVoltagesToCheck(networkElement));
    }

    private List<Double> getNominalVoltagesToCheck(Identifiable<?> identifiable, IdentifiableType type) {
        return switch (type) {
            case IdentifiableType.DANGLING_LINE, IdentifiableType.GENERATOR, IdentifiableType.LOAD, IdentifiableType.BATTERY, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.SWITCH, IdentifiableType.HVDC_CONVERTER_STATION, IdentifiableType.BUS -> Collections.singletonList(SingleNominalVoltageCriterion.getNominalVoltage(identifiable, type));
            case IdentifiableType.LINE, IdentifiableType.HVDC_LINE, IdentifiableType.TIE_LINE, IdentifiableType.TWO_WINDINGS_TRANSFORMER -> TwoNominalVoltageCriterion.getNominalVoltages(identifiable, type);
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> ThreeNominalVoltageCriterion.getNominalVoltages(identifiable, type);
            default -> Collections.emptyList();
        };
    }

    private List<Double> getNominalVoltagesToCheck(NetworkElement networkElement) {
        return Arrays.asList(networkElement.getNominalVoltage1().orElse(null), networkElement.getNominalVoltage2().orElse(null), networkElement.getNominalVoltage3().orElse(null));
    }

    private boolean filterNominalVoltages(List<Double> nominalVoltagesToCheck) {
        return nominalVoltagesToCheck.stream().filter(Objects::nonNull).anyMatch(this.voltageInterval::checkIsBetweenBound);
    }

    public VoltageInterval getVoltageInterval() {
        return this.voltageInterval;
    }
}

