/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.VoltageInterval;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import java.util.Optional;

public class SingleNominalVoltageCriterion
implements Criterion {
    private final VoltageInterval voltageInterval;

    public SingleNominalVoltageCriterion(VoltageInterval voltageInterval) {
        this.voltageInterval = Objects.requireNonNull(voltageInterval);
    }

    @Override
    @JsonIgnore
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.SINGLE_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        Double nominalVoltage = SingleNominalVoltageCriterion.getNominalVoltage(identifiable, type);
        return this.filterNominalVoltage(nominalVoltage);
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        Optional<Double> nominalVoltage = networkElement.getNominalVoltage();
        return nominalVoltage.isPresent() && this.filterNominalVoltage(nominalVoltage.get());
    }

    protected static Double getNominalVoltage(Identifiable<?> identifiable, IdentifiableType type) {
        return switch (type) {
            case IdentifiableType.LINE, IdentifiableType.TIE_LINE -> SingleNominalVoltageCriterion.getNominalVoltage(((Branch)identifiable).getTerminal1().getVoltageLevel());
            case IdentifiableType.HVDC_LINE -> SingleNominalVoltageCriterion.getNominalVoltage(((HvdcLine)identifiable).getConverterStation1().getTerminal().getVoltageLevel());
            case IdentifiableType.DANGLING_LINE, IdentifiableType.GENERATOR, IdentifiableType.LOAD, IdentifiableType.BATTERY, IdentifiableType.SHUNT_COMPENSATOR, IdentifiableType.STATIC_VAR_COMPENSATOR, IdentifiableType.BUSBAR_SECTION, IdentifiableType.HVDC_CONVERTER_STATION -> SingleNominalVoltageCriterion.getNominalVoltage(((Injection)identifiable).getTerminal().getVoltageLevel());
            case IdentifiableType.SWITCH -> SingleNominalVoltageCriterion.getNominalVoltage(((Switch)identifiable).getVoltageLevel());
            case IdentifiableType.BUS -> SingleNominalVoltageCriterion.getNominalVoltage(((Bus)identifiable).getVoltageLevel());
            default -> null;
        };
    }

    private static Double getNominalVoltage(VoltageLevel voltageLevel) {
        return voltageLevel == null ? null : Double.valueOf(voltageLevel.getNominalV());
    }

    private boolean filterNominalVoltage(Double nominalVoltage) {
        return this.voltageInterval.checkIsBetweenBound(nominalVoltage);
    }

    public VoltageInterval getVoltageInterval() {
        return this.voltageInterval;
    }
}

