/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.criteria.VoltageInterval;
import com.powsybl.iidm.criteria.json.util.DeserializerUtils;
import java.io.IOException;

public class VoltageIntervalDeserializer
extends StdDeserializer<VoltageInterval> {
    public static final String MISSING_BOUND_ATTRIBUTE_MESSAGE = "Missing \"%s\" attribute for nominal voltage interval with non-null \"%s\" attribute.";

    public VoltageIntervalDeserializer() {
        super(VoltageInterval.class);
    }

    public VoltageInterval deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "nominalVoltageLowBound": {
                    parser.nextToken();
                    context.nominalVoltageLowBound = parser.getValueAsDouble();
                    return true;
                }
                case "lowClosed": {
                    parser.nextToken();
                    context.lowClosed = parser.getValueAsBoolean();
                    return true;
                }
                case "nominalVoltageHighBound": {
                    parser.nextToken();
                    context.nominalVoltageHighBound = parser.getValueAsDouble();
                    return true;
                }
                case "highClosed": {
                    parser.nextToken();
                    context.highClosed = parser.getValueAsBoolean();
                    return true;
                }
            }
            return false;
        });
        VoltageInterval.Builder builder = VoltageInterval.builder();
        if (DeserializerUtils.checkBoundData(context.nominalVoltageLowBound, context.lowClosed, "nominalVoltageLowBound", "lowClosed", MISSING_BOUND_ATTRIBUTE_MESSAGE)) {
            builder.setLowBound(context.nominalVoltageLowBound, context.lowClosed);
        }
        if (DeserializerUtils.checkBoundData(context.nominalVoltageHighBound, context.highClosed, "nominalVoltageHighBound", "highClosed", MISSING_BOUND_ATTRIBUTE_MESSAGE)) {
            builder.setHighBound(context.nominalVoltageHighBound, context.highClosed);
        }
        return builder.build();
    }

    private static class ParsingContext {
        Double nominalVoltageLowBound;
        Boolean lowClosed;
        Double nominalVoltageHighBound;
        Boolean highClosed;

        private ParsingContext() {
        }
    }
}

