/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.VoltageInterval;
import com.powsybl.iidm.criteria.translation.NetworkElement;
import com.powsybl.iidm.criteria.util.NominalVoltageUtils;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class TwoNominalVoltageCriterion
implements Criterion {
    private final VoltageInterval voltageInterval1;
    private final VoltageInterval voltageInterval2;
    @JsonIgnore
    private final List<VoltageInterval> voltageIntervals = new ArrayList<VoltageInterval>();

    public TwoNominalVoltageCriterion(VoltageInterval voltageInterval1, VoltageInterval voltageInterval2) {
        this.voltageInterval1 = voltageInterval1;
        this.voltageInterval2 = voltageInterval2;
        if (this.voltageInterval1 != null) {
            this.voltageIntervals.add(voltageInterval1);
        }
        if (this.voltageInterval2 != null) {
            this.voltageIntervals.add(voltageInterval2);
        }
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.TWO_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        List<Double> nominalVoltages = TwoNominalVoltageCriterion.getNominalVoltages(identifiable, type);
        return nominalVoltages.size() == 2 && this.filterWithNominalVoltages(nominalVoltages.get(0), nominalVoltages.get(1));
    }

    protected static List<Double> getNominalVoltages(Identifiable<?> identifiable, IdentifiableType type) {
        if (type == IdentifiableType.TWO_WINDINGS_TRANSFORMER || type == IdentifiableType.LINE || type == IdentifiableType.TIE_LINE) {
            Branch branch = (Branch)identifiable;
            return Arrays.asList(NominalVoltageUtils.getNominalVoltage(branch.getTerminal1()), NominalVoltageUtils.getNominalVoltage(branch.getTerminal2()));
        }
        if (type == IdentifiableType.HVDC_LINE) {
            HvdcLine hvdcLine = (HvdcLine)identifiable;
            return Arrays.asList(NominalVoltageUtils.getNominalVoltage(hvdcLine.getConverterStation1().getTerminal()), NominalVoltageUtils.getNominalVoltage(hvdcLine.getConverterStation2().getTerminal()));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean filter(NetworkElement networkElement) {
        Double nominalVoltage1 = networkElement.getNominalVoltage1().orElse(null);
        Double nominalVoltage2 = networkElement.getNominalVoltage2().orElse(null);
        return this.filterWithNominalVoltages(nominalVoltage1, nominalVoltage2);
    }

    private boolean filterWithNominalVoltages(Double nominalVoltage1, Double nominalVoltage2) {
        AtomicBoolean filter = new AtomicBoolean(true);
        this.voltageIntervals.forEach(voltageInterval -> {
            if (!voltageInterval.checkIsBetweenBound(nominalVoltage1) && !voltageInterval.checkIsBetweenBound(nominalVoltage2)) {
                filter.set(false);
            }
        });
        return filter.get();
    }

    public Optional<VoltageInterval> getVoltageInterval1() {
        return Optional.ofNullable(this.voltageInterval1);
    }

    public Optional<VoltageInterval> getVoltageInterval2() {
        return Optional.ofNullable(this.voltageInterval2);
    }
}

