/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.criteria.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.NetworkElementCriterion;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetworkElementCriterionDeserializer<T extends NetworkElementCriterion>
extends StdDeserializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNetworkElementCriterionDeserializer.class);

    protected AbstractNetworkElementCriterionDeserializer(Class<T> c) {
        super(c);
    }

    protected boolean deserializeAttributes(JsonParser parser, DeserializationContext ctx, ParsingContext parsingCtx, String name, NetworkElementCriterion.NetworkElementCriterionType expectedCriterionType, Criterion.CriterionType expectedCountriesCriterionType, Criterion.CriterionType expectedNominalVoltagesCriterionType) throws IOException {
        String expectedType = expectedCriterionType.getName();
        switch (name) {
            case "countryCriterion": {
                parser.nextToken();
                parsingCtx.countryCriterion = (Criterion)JsonUtil.readValue((DeserializationContext)ctx, (JsonParser)parser, Criterion.class);
                if (parsingCtx.countryCriterion != null && parsingCtx.countryCriterion.getType() != expectedCountriesCriterionType) {
                    throw new IllegalStateException(String.format("'%s' equipment criteria only support '%s' type countryCriterion", expectedType, expectedCountriesCriterionType.name()));
                }
                return true;
            }
            case "nominalVoltageCriterion": {
                parser.nextToken();
                parsingCtx.nominalVoltageCriterion = (Criterion)JsonUtil.readValue((DeserializationContext)ctx, (JsonParser)parser, Criterion.class);
                if (parsingCtx.nominalVoltageCriterion != null && parsingCtx.nominalVoltageCriterion.getType() != expectedNominalVoltagesCriterionType) {
                    throw new IllegalStateException(String.format("'%s' equipment criteria only support '%s' type nominalVoltageCriterion", expectedType, expectedNominalVoltagesCriterionType.name()));
                }
                return true;
            }
        }
        return this.deserializeCommonAttributes(parser, parsingCtx, name, expectedCriterionType);
    }

    protected boolean deserializeCommonAttributes(JsonParser parser, ParsingContext parsingCtx, String name, NetworkElementCriterion.NetworkElementCriterionType expectedCriterionType) throws IOException {
        String expectedType = expectedCriterionType.getName();
        switch (name) {
            case "name": {
                parsingCtx.name = parser.nextTextValue();
                return true;
            }
            case "version": {
                parser.nextToken();
                return true;
            }
            case "type": {
                String type = parser.nextTextValue();
                if (!type.equals(expectedType)) {
                    throw new IllegalStateException(String.format("'type' is expected to be '%s' but encountered value was '%s'", expectedType, type));
                }
                return true;
            }
        }
        LOGGER.warn("Ignored element '{}' for criterion of type '{}'", (Object)name, (Object)expectedType);
        return false;
    }

    protected static class ParsingContext {
        String name = null;
        Criterion countryCriterion = null;
        Criterion nominalVoltageCriterion = null;

        protected ParsingContext() {
        }
    }
}

